"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditMonitorNotFound = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
var _api = require("../../state/monitor_management/api");
var _monitor_not_found_page = require("../monitor_details/monitor_not_found_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditMonitorNotFound = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LeftoverIntegrationFound, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_monitor_not_found_page.MonitorNotFoundPage, null));
};
exports.EditMonitorNotFound = EditMonitorNotFound;
const LeftoverIntegrationFound = () => {
  const {
    packagePolicyId
  } = (0, _hooks.useGetUrlParams)();
  const updateUrlParams = (0, _hooks.useUrlParams)()[1];
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => {
    if (!packagePolicyId || !isDeleting) return;
    return (0, _api.deletePackagePolicy)(packagePolicyId);
  }, [isDeleting, packagePolicyId]);
  (0, _react.useEffect)(() => {
    if (isDeleting && data && !loading) {
      updateUrlParams({
        packagePolicyId: undefined
      }, true);
      setIsDeleting(false);
    }
  }, [data, isDeleting, loading, updateUrlParams]);
  if (!packagePolicyId) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Leftover integration found",
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.leftOver.errors.title",
    defaultMessage: "Please click on the button below to delete the integration. Normally this should not happen. Since the monitor has been deleted, the integration was supposed to be deleted automatically. If this happens often, report it by "
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsLeftoverIntegrationFoundCreatingAnIssueLink",
    href: "https://github.com/elastic/kibana/issues/new/choose"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.leftOver.errors.createIssue",
    defaultMessage: "creating an issue."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsUseMonitorNotFoundDeleteIntegrationButton",
    color: "danger",
    isLoading: loading && isDeleting,
    onClick: () => {
      setIsDeleting(true);
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.leftOver.errors.delete",
    defaultMessage: "Delete integration"
  })));
};