"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEBSITE_URL_PLACEHOLDER = exports.WEBSITE_URL_LABEL = exports.WEBSITE_URL_HELP_TEXT = exports.URL_REQUIRED_LABEL = exports.SimpleMonitorForm = exports.MONITOR_SUCCESS_LABEL = exports.MONITOR_FAILURE_LABEL = exports.CREATE_MONITOR_LABEL = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_simple_monitor = require("./use_simple_monitor");
var _service_locations = require("./form_fields/service_locations");
var _runtime_types = require("../../../../../common/runtime_types");
var _use_capabilities = require("../../../../hooks/use_capabilities");
var _use_form_wrapped = require("../../../../hooks/use_form_wrapped");
var _permissions = require("../common/components/permissions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SimpleMonitorForm = () => {
  const {
    control,
    register,
    handleSubmit,
    formState: {
      errors,
      isValid,
      isSubmitted
    }
  } = (0, _use_form_wrapped.useFormWrapped)({
    mode: 'onSubmit',
    reValidateMode: 'onChange',
    shouldFocusError: true,
    defaultValues: {
      urls: '',
      locations: []
    }
  });
  const [monitorData, setMonitorData] = (0, _react.useState)();
  const onSubmit = data => {
    setMonitorData(data);
  };
  const {
    loading,
    data: newMonitor
  } = (0, _use_simple_monitor.useSimpleMonitor)({
    monitorData
  });
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const hasURLError = !!(errors !== null && errors !== void 0 && errors[_runtime_types.ConfigKey.URLS]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: handleSubmit(onSubmit),
    component: "form",
    isInvalid: isSubmitted && !isValid && !loading && !(newMonitor !== null && newMonitor !== void 0 && newMonitor.id),
    noValidate: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: WEBSITE_URL_LABEL,
    helpText: !hasURLError ? WEBSITE_URL_HELP_TEXT : '',
    isInvalid: !!(errors !== null && errors !== void 0 && errors[_runtime_types.ConfigKey.URLS]),
    error: hasURLError ? URL_REQUIRED_LABEL : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    fullWidth: true
  }, register(_runtime_types.ConfigKey.URLS, {
    required: true
  }), {
    isInvalid: !!(errors !== null && errors !== void 0 && errors[_runtime_types.ConfigKey.URLS]),
    "data-test-subj": `${_runtime_types.ConfigKey.URLS}-input`,
    tabIndex: 0
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_service_locations.ServiceLocationsField, {
    errors: errors,
    control: control
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canEditSynthetics
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    fill: true,
    iconType: "plusInCircleFilled",
    isLoading: loading,
    "data-test-subj": "syntheticsMonitorConfigSubmitButton",
    disabled: !canEditSynthetics
  }, CREATE_MONITOR_LABEL)))));
};
exports.SimpleMonitorForm = SimpleMonitorForm;
const WEBSITE_URL_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.websiteUrlLabel', {
  defaultMessage: 'Website URL'
});
exports.WEBSITE_URL_LABEL = WEBSITE_URL_LABEL;
const WEBSITE_URL_PLACEHOLDER = _i18n.i18n.translate('xpack.synthetics.monitorManagement.websiteUrlPlaceholder', {
  defaultMessage: 'Enter a website URL'
});
exports.WEBSITE_URL_PLACEHOLDER = WEBSITE_URL_PLACEHOLDER;
const WEBSITE_URL_HELP_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.websiteUrlHelpText', {
  defaultMessage: `For example, your company's homepage or https://elastic.co.`
});
exports.WEBSITE_URL_HELP_TEXT = WEBSITE_URL_HELP_TEXT;
const CREATE_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.createMonitorLabel', {
  defaultMessage: 'Create monitor'
});
exports.CREATE_MONITOR_LABEL = CREATE_MONITOR_LABEL;
const MONITOR_SUCCESS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorAddedSuccessMessage', {
  defaultMessage: 'Monitor added successfully.'
});
exports.MONITOR_SUCCESS_LABEL = MONITOR_SUCCESS_LABEL;
const MONITOR_FAILURE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorFailureMessage', {
  defaultMessage: 'Monitor was unable to be saved. Please try again later.'
});
exports.MONITOR_FAILURE_LABEL = MONITOR_FAILURE_LABEL;
const URL_REQUIRED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.urlRequiredLabel', {
  defaultMessage: 'URL is required'
});
exports.URL_REQUIRED_LABEL = URL_REQUIRED_LABEL;