"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceLocationsField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _location_formatter = require("../../../../../../common/utils/location_formatter");
var _state = require("../../../state");
var _monitor_management = require("../../../../../../common/constants/monitor_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ServiceLocationsField = ({
  errors,
  control
}) => {
  const {
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: LOCATIONS_LABEL,
    helpText: !(errors !== null && errors !== void 0 && errors[_monitor_management.ConfigKey.LOCATIONS]) ? SELECT_ONE_OR_MORE_LOCATIONS_DETAILS : undefined,
    isInvalid: !!(errors !== null && errors !== void 0 && errors[_monitor_management.ConfigKey.LOCATIONS]),
    error: SELECT_ONE_OR_MORE_LOCATIONS
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: _monitor_management.ConfigKey.LOCATIONS,
    control: control,
    rules: {
      required: true
    },
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
      fullWidth: true,
      "aria-label": SELECT_ONE_OR_MORE_LOCATIONS,
      options: locations.map(location => ({
        ...location,
        'data-test-subj': `syntheticsServiceLocation--${location.id}`
      })),
      selectedOptions: field.value,
      isClearable: true,
      "data-test-subj": "syntheticsServiceLocations"
    }, field, {
      onChange: selectedOptions => field.onChange(selectedOptions.map(loc => (0, _location_formatter.formatLocation)(loc))),
      isInvalid: !!(errors !== null && errors !== void 0 && errors[_monitor_management.ConfigKey.LOCATIONS])
    }))
  }));
};
exports.ServiceLocationsField = ServiceLocationsField;
const SELECT_ONE_OR_MORE_LOCATIONS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.selectOneOrMoreLocations', {
  defaultMessage: 'Select one or more locations.'
});
const SELECT_ONE_OR_MORE_LOCATIONS_DETAILS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.selectOneOrMoreLocationsDetails', {
  defaultMessage: 'Select locations where monitors will be executed.'
});
const LOCATIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.locationsLabel', {
  defaultMessage: 'Locations'
});