"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailedTestsList = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _test_time_formats = require("../../../utils/monitor_test_result/test_time_formats");
var _use_date_format = require("../../../../../hooks/use_date_format");
var _test_details_link = require("../../common/links/test_details_link");
var _contexts = require("../../../contexts");
var _use_selected_location = require("../../monitor_details/hooks/use_selected_location");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FailedTestsList = ({
  failedTests,
  loading
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(5);
  const [sortField, setSortField] = (0, _react.useState)('@timestamp');
  const [sortDirection, setSortDirection] = (0, _react.useState)('desc');
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const items = failedTests.slice(pageIndex * pageSize, pageIndex * pageSize + pageSize);
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const formatter = (0, _use_date_format.useDateFormat)();
  const columns = [{
    field: '@timestamp',
    name: TIMESTAMP_LABEL,
    sortable: true,
    render: (value, item) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "failed-test-link",
        href: `${basePath}/app/synthetics/monitor/${monitorId}/test-run/${item.monitor.check_group}`
      }, formatter(value));
    }
  }, {
    field: 'monitor.duration.us',
    name: MONITOR_DURATION_LABEL,
    align: 'right',
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, (0, _test_time_formats.formatTestDuration)(value))
  }];
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: failedTests.length,
    pageSizeOptions: [3, 5, 8]
  };
  const getRowProps = item => {
    const {
      state
    } = item;
    if (state !== null && state !== void 0 && state.id) {
      return {
        'data-test-subj': `row-${state.id}`,
        onClick: evt => {
          history.push((0, _test_details_link.getTestRunDetailRelativeLink)({
            monitorId,
            checkGroup: item.monitor.check_group,
            locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id
          }));
        }
      };
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: ERRORS_LIST_LABEL,
    loading: loading,
    items: items,
    columns: columns,
    pagination: pagination,
    sorting: {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    },
    onChange: ({
      page = {},
      sort = {}
    }) => {
      const {
        index: pIndex,
        size: pSize
      } = page;
      const {
        field: sField,
        direction: sDirection
      } = sort;
      setPageIndex(pIndex);
      setPageSize(pSize);
      setSortField(sField);
      setSortDirection(sDirection);
    },
    rowProps: getRowProps
  }));
};
exports.FailedTestsList = FailedTestsList;
const ERRORS_LIST_LABEL = _i18n.i18n.translate('xpack.synthetics.errorsList.label', {
  defaultMessage: 'Errors list'
});
const MONITOR_DURATION_LABEL = _i18n.i18n.translate('xpack.synthetics.testDuration.label', {
  defaultMessage: 'Test duration'
});
const TIMESTAMP_LABEL = _i18n.i18n.translate('xpack.synthetics.timestamp.label', {
  defaultMessage: '@timestamp'
});