"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScreenshotUrl = exports.formatScreenshotStepsCount = exports.JourneyScreenshotDialog = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _constants = require("../../../../../../common/constants");
var _contexts = require("../../../contexts");
var _use_retrieve_step_image = require("../monitor_test_result/use_retrieve_step_image");
var _screenshot_image = require("./screenshot_image");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JourneyScreenshotDialog = ({
  timestamp,
  checkGroup,
  initialImgSrc,
  initialStepNumber,
  isOpen,
  onClose
}) => {
  var _imageResult$imgPath;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isSmall = (0, _eui.useIsWithinMaxBreakpoint)('m');
  const [stepNumber, setStepNumber] = (0, _react.useState)(initialStepNumber);
  const {
    basePath
  } = (0, _react.useContext)(_contexts.SyntheticsSettingsContext);
  const imgPath = getScreenshotUrl({
    basePath,
    checkGroup,
    stepNumber
  });
  const imageResult = (0, _use_retrieve_step_image.useRetrieveStepImage)({
    hasIntersected: true,
    stepStatus: 'complete',
    imgPath,
    retryFetchOnRevisit: false,
    checkGroup,
    timestamp
  });
  const {
    url,
    loading,
    stepName,
    maxSteps
  } = (_imageResult$imgPath = imageResult === null || imageResult === void 0 ? void 0 : imageResult[imgPath]) !== null && _imageResult$imgPath !== void 0 ? _imageResult$imgPath : {};
  const imgSrc = stepNumber === initialStepNumber ? initialImgSrc !== null && initialImgSrc !== void 0 ? initialImgSrc : url : url;
  const stepCountLabel = formatScreenshotStepsCount(stepNumber, maxSteps !== null && maxSteps !== void 0 ? maxSteps : stepNumber);
  (0, _react.useEffect)(() => {
    if (isOpen) {
      setStepNumber(initialStepNumber);
    }
    // do not include initialStepNumber
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isOpen, setStepNumber]);
  const onKeyDown = (0, _react.useCallback)(evt => {
    if ((evt === null || evt === void 0 ? void 0 : evt.key) === 'Escape') {
      onClose();
      return;
    }
    if (!maxSteps) {
      return;
    }
    const isLeft = (evt === null || evt === void 0 ? void 0 : evt.key) === 'ArrowLeft';
    const isRight = (evt === null || evt === void 0 ? void 0 : evt.key) === 'ArrowRight';
    if (isLeft && stepNumber > 1) {
      setStepNumber(s => s - 1);
    }
    if (isRight && stepNumber < maxSteps) {
      setStepNumber(s => s + 1);
    }
  }, [setStepNumber, stepNumber, maxSteps, onClose]);
  return isOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: evt => {
      var _evt$stopPropagation;
      evt === null || evt === void 0 ? void 0 : (_evt$stopPropagation = evt.stopPropagation) === null || _evt$stopPropagation === void 0 ? void 0 : _evt$stopPropagation.call(evt);
      onClose();
    },
    css: {
      outline: 0,
      maxWidth: 'calc(90vw)',
      maxHeight: 'calc(90vh)',
      borderRadius: 0,
      padding: 0
    },
    onKeyDown: onKeyDown
  }, /*#__PURE__*/_react.default.createElement(ModalBodyStyled, {
    css: {
      display: 'flex'
    }
  }, /*#__PURE__*/_react.default.createElement(_screenshot_image.ScreenshotImage, {
    label: stepCountLabel,
    imgSrc: imgSrc,
    isLoading: !!loading,
    animateLoading: false,
    hasBorder: false,
    size: 'full'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    css: {
      outline: 0,
      backgroundColor: euiTheme.colors.lightShade,
      display: 'inline-block',
      width: '100%',
      textDecoration: 'none',
      padding: 0
    },
    onClick: evt => {
      // we don't want this to be captured by row click which leads to step list page
      evt.stopPropagation();
    },
    onKeyDown: _evt => {
      // Just to satisfy ESLint
    }
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "screenshotImageLoadingProgress",
    size: "xs"
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "screenshotImagePreviousButton",
    css: {
      marginLeft: isSmall ? 0 : 'auto'
    },
    disabled: loading || !maxSteps || stepNumber === 1,
    onClick: evt => {
      setStepNumber(s => s - 1);
      evt.preventDefault();
    },
    iconType: "arrowLeft",
    "aria-label": prevAriaLabel
  }, prevAriaLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      flexBasis: 'fit-content'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: euiTheme.colors.text
  }, stepCountLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "screenshotImageNextButton",
    css: {
      marginRight: isSmall ? 0 : 'auto'
    },
    disabled: loading || !maxSteps || stepNumber === maxSteps,
    onClick: evt => {
      setStepNumber(s => s + 1);
      evt.stopPropagation();
    },
    iconType: "arrowRight",
    iconSide: "right",
    "aria-label": nextAriaLabel
  }, nextAriaLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: euiTheme.colors.text,
    css: {
      outline: 0,
      padding: euiTheme.size.m,
      paddingTop: 0,
      textAlign: 'center',
      overflow: 'hidden',
      textOverflow: 'ellipsis'
    },
    className: "eui-textNoWrap",
    size: "s"
  }, stepName)))) : null;
};
exports.JourneyScreenshotDialog = JourneyScreenshotDialog;
const ModalBodyStyled = (0, _common.euiStyled)(_eui.EuiModalBody)`
  &&& {
    & > div {
      display: flex;
      justify-content: center;
      align-items: center;
      margin-top: 24px;
    }
  }
`;
const getScreenshotUrl = ({
  basePath,
  checkGroup,
  stepNumber
}) => {
  if (!checkGroup) {
    return '';
  }
  return `${basePath}${_constants.SYNTHETICS_API_URLS.JOURNEY_SCREENSHOT.replace('{checkGroup}', checkGroup).replace('{stepIndex}', stepNumber.toString())}`;
};
exports.getScreenshotUrl = getScreenshotUrl;
const formatScreenshotStepsCount = (stepNumber, totalSteps) => _i18n.i18n.translate('xpack.synthetics.monitor.stepOfSteps', {
  defaultMessage: 'Step: {stepNumber} of {totalSteps}',
  values: {
    stepNumber,
    totalSteps
  }
});
exports.formatScreenshotStepsCount = formatScreenshotStepsCount;
const prevAriaLabel = _i18n.i18n.translate('xpack.synthetics.monitor.step.previousStep', {
  defaultMessage: 'Previous step'
});
const nextAriaLabel = _i18n.i18n.translate('xpack.synthetics.monitor.step.nextStep', {
  defaultMessage: 'Next step'
});