"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseBadgeStatus = exports.getTextColorForMonitorStatus = exports.getBadgeColorForMonitorStatus = exports.StatusBadge = exports.SKIPPED_LABEL = exports.FAILED_LABEL = exports.COMPLETE_LABEL = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusBadge = ({
  status
}) => {
  if (status === 'unknown') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: getBadgeColorForMonitorStatus(status),
    css: {
      maxWidth: 'max-content'
    }
  }, status === 'succeeded' ? COMPLETE_LABEL : status === 'failed' ? FAILED_LABEL : SKIPPED_LABEL);
};
exports.StatusBadge = StatusBadge;
const parseBadgeStatus = status => {
  switch (status) {
    case 'succeeded':
    case 'success':
    case 'up':
      return 'succeeded';
    case 'fail':
    case 'failed':
    case 'down':
      return 'failed';
    case 'skip':
    case 'skipped':
      return 'skipped';
    default:
      return 'unknown';
  }
};
exports.parseBadgeStatus = parseBadgeStatus;
const getBadgeColorForMonitorStatus = status => {
  return status === 'succeeded' ? 'success' : status === 'failed' ? 'danger' : 'default';
};
exports.getBadgeColorForMonitorStatus = getBadgeColorForMonitorStatus;
const getTextColorForMonitorStatus = status => {
  return status === 'skipped' ? 'disabledText' : 'text';
};
exports.getTextColorForMonitorStatus = getTextColorForMonitorStatus;
const COMPLETE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.complete', {
  defaultMessage: 'Complete'
});
exports.COMPLETE_LABEL = COMPLETE_LABEL;
const FAILED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.failed', {
  defaultMessage: 'Failed'
});
exports.FAILED_LABEL = FAILED_LABEL;
const SKIPPED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.skipped', {
  defaultMessage: 'Skipped'
});
exports.SKIPPED_LABEL = SKIPPED_LABEL;