"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MISSING_RULES_PRIVILEGES_LABEL = exports.AlertingCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _common = require("@kbn/observability-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _reactUse = require("react-use");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _settings = require("../../../state/settings");
var _selectors = require("../../../state/alert_rules/selectors");
var _state = require("../../../state");
var _actions = require("../../../state/settings/actions");
var _contexts = require("../../../contexts");
var _runtime_types = require("../../../../../../common/runtime_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertingCallout = ({
  isAlertingEnabled
}) => {
  var _useSyntheticsStartPl, _useSyntheticsStartPl2;
  const dispatch = (0, _reactRedux.useDispatch)();
  const defaultRules = (0, _reactRedux.useSelector)(_selectors.selectSyntheticsAlerts);
  const rulesLoaded = (0, _reactRedux.useSelector)(_selectors.selectSyntheticsAlertsLoaded);
  const {
    settings
  } = (0, _reactRedux.useSelector)(_settings.selectDynamicSettings);
  const hasDefaultConnector = !settings || !(0, _lodash.isEmpty)(settings === null || settings === void 0 ? void 0 : settings.defaultConnectors);
  const {
    canSave
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    data: {
      monitors
    },
    loaded: monitorsLoaded
  } = (0, _reactRedux.useSelector)(_state.selectMonitorListState);
  const syntheticsLocators = (_useSyntheticsStartPl = (0, _contexts.useSyntheticsStartPlugins)()) === null || _useSyntheticsStartPl === void 0 ? void 0 : (_useSyntheticsStartPl2 = _useSyntheticsStartPl.share) === null || _useSyntheticsStartPl2 === void 0 ? void 0 : _useSyntheticsStartPl2.url.locators;
  const locator = syntheticsLocators === null || syntheticsLocators === void 0 ? void 0 : syntheticsLocators.get(_common.syntheticsSettingsLocatorID);
  const {
    data: url
  } = (0, _public.useFetcher)(() => {
    return locator === null || locator === void 0 ? void 0 : locator.getUrl({});
  }, [locator]);
  const hasAlertingConfigured = isAlertingEnabled !== null && isAlertingEnabled !== void 0 ? isAlertingEnabled : monitorsLoaded && monitors.some(monitor => {
    var _monitor$ConfigKey$AL, _monitor$ConfigKey$AL2;
    return (_monitor$ConfigKey$AL = monitor[_runtime_types.ConfigKey.ALERT_CONFIG]) === null || _monitor$ConfigKey$AL === void 0 ? void 0 : (_monitor$ConfigKey$AL2 = _monitor$ConfigKey$AL.status) === null || _monitor$ConfigKey$AL2 === void 0 ? void 0 : _monitor$ConfigKey$AL2.enabled;
  });
  const showCallout = !hasDefaultConnector && hasAlertingConfigured;
  const hasDefaultRules = !rulesLoaded || Boolean((defaultRules === null || defaultRules === void 0 ? void 0 : defaultRules.statusRule) && (defaultRules === null || defaultRules === void 0 ? void 0 : defaultRules.tlsRule));
  const missingRules = !hasDefaultRules && !canSave;
  (0, _react.useEffect)(() => {
    dispatch(_actions.getDynamicSettingsAction.get());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(MissingRulesCallout, {
    url: url,
    missingConfig: Boolean(showCallout),
    missingRules: missingRules
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.AlertingCallout = AlertingCallout;
const MissingRulesCallout = ({
  url,
  missingRules,
  missingConfig
}) => {
  const [isHidden, setIsHidden] = (0, _reactUse.useSessionStorage)('MissingRulesCalloutHidden', false);
  if (!missingConfig && !missingRules || isHidden) {
    return null;
  }
  const point = missingRules === missingConfig ? '* ' : '';
  const configCallout = missingConfig ? /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, `${point}${MISSING_CONFIG_LABEL}`) : null;
  const rulesCallout = missingRules ? /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, `${point}${MISSING_RULES_PRIVILEGES_LABEL}`) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.alerting.noConnectorsCallout.header",
      defaultMessage: "Alerts are not being sent"
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, configCallout, rulesCallout), missingConfig && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsAlertingCalloutLinkButtonButton",
    href: url,
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.alerting.noConnectorsCallout.button",
    defaultMessage: "Configure now"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsMissingRulesCalloutRemindMeLaterButton",
    onClick: () => {
      setIsHidden(true);
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.alerting.remindMeLater.button",
    defaultMessage: "Remind me later"
  })));
};
const MISSING_CONFIG_LABEL = _i18n.i18n.translate('xpack.synthetics.alerting.noConnectorsCallout.content', {
  defaultMessage: 'You have monitors with alerting enabled, but there is no default connector configured to send those alerts.'
});
const MISSING_RULES_PRIVILEGES_LABEL = _i18n.i18n.translate('xpack.synthetics.alerting.missingRules.content', {
  defaultMessage: 'You have monitors with alerting enabled, but there is no rules configured to send those alerts. Default rules are automatically created when user with write privileges opens Synthetics app.'
});
exports.MISSING_RULES_PRIVILEGES_LABEL = MISSING_RULES_PRIVILEGES_LABEL;