"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsErrorRouteFromMonitorId = void 0;
var _get_monitor_url = require("./get_monitor_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSyntheticsErrorRouteFromMonitorId = ({
  configId,
  stateId,
  locationId
}) => (0, _get_monitor_url.format)({
  pathname: encodeURI(`/app/synthetics/monitor/${configId}/errors/${stateId}`),
  query: {
    locationId
  }
});
exports.getSyntheticsErrorRouteFromMonitorId = getSyntheticsErrorRouteFromMonitorId;