"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsPrivateLocationsType = exports.PrivateLocationCodec = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivateLocationCodec = t.intersection([t.interface({
  label: t.string,
  id: t.string,
  agentPolicyId: t.string,
  concurrentMonitors: t.number
}), t.partial({
  isServiceManaged: t.boolean,
  isInvalid: t.boolean,
  tags: t.array(t.string),
  /* Empty Lat lon was accidentally saved as an empty string instead of undefined or null
   * Need a migration to fix */
  geo: t.interface({
    lat: t.union([t.string, t.number]),
    lon: t.union([t.string, t.number])
  })
})]);
exports.PrivateLocationCodec = PrivateLocationCodec;
const SyntheticsPrivateLocationsType = t.type({
  locations: t.array(PrivateLocationCodec)
});
exports.SyntheticsPrivateLocationsType = SyntheticsPrivateLocationsType;