"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = exports.configValidator = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _validators = require("@kbn/actions-plugin/server/sub_action_framework/helpers/validators");
var _constants = require("../../../common/gen_ai/constants");
var _schema = require("../../../common/gen_ai/schema");
var _gen_ai = require("./gen_ai");
var _render = require("./render");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectorType = () => ({
  id: _constants.GEN_AI_CONNECTOR_ID,
  name: _constants.GEN_AI_TITLE,
  Service: _gen_ai.GenAiConnector,
  schema: {
    config: _schema.GenAiConfigSchema,
    secrets: _schema.GenAiSecretsSchema
  },
  validators: [{
    type: _types.ValidatorType.CONFIG,
    validator: configValidator
  }],
  supportedFeatureIds: [_common.GeneralConnectorFeatureId],
  minimumLicenseRequired: 'enterprise',
  renderParameterTemplates: _render.renderParameterTemplates
});
exports.getConnectorType = getConnectorType;
const configValidator = (configObject, validatorServices) => {
  try {
    (0, _validators.assertURL)(configObject.apiUrl);
    (0, _server.urlAllowListValidator)('apiUrl')(configObject, validatorServices);
    if (configObject.apiProvider !== _constants.OpenAiProviderType.OpenAi && configObject.apiProvider !== _constants.OpenAiProviderType.AzureAi) {
      throw new Error(`API Provider is not supported${configObject.apiProvider && configObject.apiProvider.length ? `: ${configObject.apiProvider}` : ``}`);
    }
    return configObject;
  } catch (err) {
    throw new Error(_i18n.i18n.translate('xpack.stackConnectors.genAi.configurationErrorApiProvider', {
      defaultMessage: 'Error configuring Generative AI action: {err}',
      values: {
        err
      }
    }));
  }
};
exports.configValidator = configValidator;