"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateConnector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _servicenow_config = require("../../../../common/servicenow_config");
var _credentials_api_url = require("./credentials_api_url");
var _auth_types = require("./auth_types");
var _sn_store_button = require("./sn_store_button");
var _application_required_callout = require("./application_required_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const title = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateFormTitle', {
  defaultMessage: 'Update ServiceNow connector'
});
const step1InstallTitle = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateFormInstallTitle', {
  defaultMessage: 'Install the Elastic ServiceNow app'
});
const step2InstanceUrlTitle = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateFormUrlTitle', {
  defaultMessage: 'Enter your ServiceNow instance URL'
});
const step3CredentialsTitle = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateFormCredentialsTitle', {
  defaultMessage: 'Provide authentication credentials'
});
const cancelButtonText = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.cancelButtonText', {
  defaultMessage: 'Cancel'
});
const confirmButtonText = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.confirmButtonText', {
  defaultMessage: 'Update'
});
const warningMessage = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.warningMessage', {
  defaultMessage: 'This updates all instances of this connector and cannot be reversed.'
});
const PATH_PREFIX = 'updatedConnector.';
const UpdateConnectorComponent = ({
  actionTypeId,
  isOAuth,
  isLoading,
  readOnly,
  onCancel,
  onConfirm,
  updateErrorMessage
}) => {
  var _snExternalServiceCon, _snExternalServiceCon2;
  const {
    form
  } = (0, _hook_form_lib.useForm)();
  const {
    submit,
    isValid
  } = form;
  const onSubmit = (0, _react.useCallback)(async () => {
    const {
      data,
      isValid: isSubmitValid
    } = await submit();
    if (!isSubmitValid) {
      return;
    }
    const {
      updatedConnector
    } = data;
    onConfirm(updatedConnector);
  }, [onConfirm, submit]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onCancel,
    "data-test-subj": "updateConnectorForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h1", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "m",
      color: "danger",
      iconType: "warning",
      "data-test-subj": "snUpdateInstallationCallout",
      title: warningMessage
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: step1InstallTitle,
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.serviceNow.appRunning",
        defaultMessage: "The Elastic App from the ServiceNow app store must be installed prior to running the update. {visitLink} to install the app",
        values: {
          visitLink: /*#__PURE__*/_react.default.createElement(_sn_store_button.SNStoreLink, {
            appId: (_snExternalServiceCon = _servicenow_config.snExternalServiceConfig[actionTypeId].appId) !== null && _snExternalServiceCon !== void 0 ? _snExternalServiceCon : ''
          })
        }
      })
    }, {
      title: step2InstanceUrlTitle,
      children: /*#__PURE__*/_react.default.createElement(_credentials_api_url.CredentialsApiUrl, {
        readOnly: readOnly,
        isLoading: isLoading,
        pathPrefix: PATH_PREFIX
      })
    }, {
      title: step3CredentialsTitle,
      children: isOAuth ? /*#__PURE__*/_react.default.createElement(_auth_types.OAuth, {
        readOnly: readOnly,
        isLoading: isLoading,
        pathPrefix: PATH_PREFIX
      }) : /*#__PURE__*/_react.default.createElement(_auth_types.CredentialsAuth, {
        readOnly: readOnly,
        isLoading: isLoading,
        pathPrefix: PATH_PREFIX
      })
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, updateErrorMessage != null ? /*#__PURE__*/_react.default.createElement(_application_required_callout.ApplicationRequiredCallout, {
    message: updateErrorMessage,
    appId: (_snExternalServiceCon2 = _servicenow_config.snExternalServiceConfig[actionTypeId].appId) !== null && _snExternalServiceCon2 !== void 0 ? _snExternalServiceCon2 : ''
  }) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "snUpdateInstallationCancel",
    onClick: onCancel
  }, cancelButtonText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "snUpdateInstallationSubmit",
    onClick: onSubmit,
    color: "danger",
    fill: true,
    disabled: !isValid,
    isLoading: isLoading
  }, confirmButtonText))))));
};
const UpdateConnector = /*#__PURE__*/(0, _react.memo)(UpdateConnectorComponent);
exports.UpdateConnector = UpdateConnector;