"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _use_get_dashboard = require("./use_get_dashboard");
var _constants = require("../../../common/gen_ai/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants2 = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const GenerativeAiConnectorFields = ({
  readOnly,
  isEdit
}) => {
  const {
    getFieldDefaultValue
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    id,
    name
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.apiProvider']
  });
  const {
    services: {
      application: {
        navigateToUrl
      }
    }
  } = (0, _public.useKibana)();
  const {
    dashboardUrl
  } = (0, _use_get_dashboard.useGetDashboard)({
    connectorId: id
  });
  const onClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (dashboardUrl) {
      navigateToUrl(dashboardUrl);
    }
  }, [dashboardUrl, navigateToUrl]);
  const selectedProviderDefaultValue = (0, _react.useMemo)(() => {
    var _getFieldDefaultValue;
    return (_getFieldDefaultValue = getFieldDefaultValue('config.apiProvider')) !== null && _getFieldDefaultValue !== void 0 ? _getFieldDefaultValue : _constants.OpenAiProviderType.OpenAi;
  }, [getFieldDefaultValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.apiProvider",
    component: _components.SelectField,
    config: {
      label: i18n.API_PROVIDER_LABEL,
      defaultValue: selectedProviderDefaultValue,
      validations: [{
        validator: emptyField(i18n.API_PROVIDER_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'config.apiProvider-select',
        options: _constants2.providerOptions,
        fullWidth: true,
        hasNoInitialSelection: true,
        disabled: readOnly,
        readOnly
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), config != null && config.apiProvider === _constants.OpenAiProviderType.OpenAi && /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: _constants2.openAiConfig,
    secretsFormSchema: _constants2.openAiSecrets
  }), config != null && config.apiProvider === _constants.OpenAiProviderType.AzureAi && /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: _constants2.azureAiConfig,
    secretsFormSchema: _constants2.azureAiSecrets
  }), isEdit && dashboardUrl != null && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "link-gen-ai-token-dashboard",
    onClick: onClick
  }, i18n.USAGE_DASHBOARD_LINK(selectedProviderDefaultValue, name)));
};

// eslint-disable-next-line import/no-default-export
exports.default = GenerativeAiConnectorFields;
module.exports = exports.default;