"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlackApiSecretsSchema = exports.SlackApiParamsSchema = exports.SlackApiConfigSchema = exports.PostMessageSubActionParamsSchema = exports.PostMessageParamsSchema = exports.GetChannelsParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SlackApiSecretsSchema = _configSchema.schema.object({
  token: _configSchema.schema.string({
    minLength: 1
  })
});
exports.SlackApiSecretsSchema = SlackApiSecretsSchema;
const SlackApiConfigSchema = _configSchema.schema.object({}, {
  defaultValue: {}
});
exports.SlackApiConfigSchema = SlackApiConfigSchema;
const GetChannelsParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('getChannels')
});
exports.GetChannelsParamsSchema = GetChannelsParamsSchema;
const PostMessageSubActionParamsSchema = _configSchema.schema.object({
  channels: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 1
  }),
  text: _configSchema.schema.string({
    minLength: 1
  })
});
exports.PostMessageSubActionParamsSchema = PostMessageSubActionParamsSchema;
const PostMessageParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('postMessage'),
  subActionParams: PostMessageSubActionParamsSchema
});
exports.PostMessageParamsSchema = PostMessageParamsSchema;
const SlackApiParamsSchema = _configSchema.schema.oneOf([GetChannelsParamsSchema, PostMessageParamsSchema]);
exports.SlackApiParamsSchema = SlackApiParamsSchema;