"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntitiesAndGenerateAlerts = getEntitiesAndGenerateAlerts;
var _constants = require("../constants");
var _alert_context = require("./alert_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEntitiesAndGenerateAlerts(prevLocationMap, currLocationMap, alertFactory, shapesIdsNamesMap, windowEnd) {
  const activeEntities = new Map([...prevLocationMap, ...currLocationMap]);
  const inactiveEntities = new Map();
  activeEntities.forEach((containments, entityName) => {
    // Generate alerts
    containments.forEach(containment => {
      if (containment.shapeLocationId !== _constants.OTHER_CATEGORY) {
        const context = (0, _alert_context.getContainedAlertContext)({
          entityName,
          containment,
          shapesIdsNamesMap,
          windowEnd
        });
        alertFactory.create((0, _alert_context.getAlertId)(entityName, context.containingBoundaryName)).scheduleActions(_constants.ActionGroupId, context);
      }
    });

    // Entity in "other" filter bucket is no longer contained by any boundary and switches from "active" to "inactive"
    if (containments[0].shapeLocationId === _constants.OTHER_CATEGORY) {
      inactiveEntities.set(entityName, containments);
      activeEntities.delete(entityName);
      return;
    }
    const otherCatIndex = containments.findIndex(({
      shapeLocationId
    }) => shapeLocationId === _constants.OTHER_CATEGORY);
    if (otherCatIndex >= 0) {
      const afterOtherLocationsArr = containments.slice(0, otherCatIndex);
      activeEntities.set(entityName, afterOtherLocationsArr);
    } else {
      activeEntities.set(entityName, containments);
    }
  });
  return {
    activeEntities,
    inactiveEntities
  };
}