"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityIndexExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _types = require("../../types");
var _geo_index_pattern_select = require("../util_components/geo_index_pattern_select");
var _single_field_select = require("../util_components/single_field_select");
var _expression_with_popover = require("../util_components/expression_with_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityIndexExpression = ({
  setAlertParamsDate,
  setAlertParamsGeoField,
  errors,
  setIndexPattern,
  indexPattern,
  isInvalid,
  dateField: timeField,
  geoField,
  data,
  unifiedSearch
}) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const IndexPatternSelect = unifiedSearch.ui && unifiedSearch.ui.IndexPatternSelect || null;
  const usePrevious = value => {
    const ref = (0, _react.useRef)();
    (0, _react.useEffect)(() => {
      ref.current = value;
    });
    return ref.current;
  };
  const oldIndexPattern = usePrevious(indexPattern);
  const fields = (0, _react.useRef)({
    dateFields: [],
    geoFields: []
  });
  (0, _react.useEffect)(() => {
    if (oldIndexPattern !== indexPattern) {
      fields.current.geoFields = indexPattern.fields && indexPattern.fields.length && indexPattern.fields.filter(field => _types.ES_GEO_FIELD_TYPES.includes(field.type)) || [];
      if (fields.current.geoFields.length) {
        setAlertParamsGeoField(fields.current.geoFields[0].name);
      }
      fields.current.dateFields = indexPattern.fields && indexPattern.fields.length && indexPattern.fields.filter(field => field.type === 'date') || [];
      if (fields.current.dateFields.length) {
        setAlertParamsDate(fields.current.dateFields[0].name);
      }
    }
  }, [indexPattern, oldIndexPattern, setAlertParamsDate, setAlertParamsGeoField]);
  const indexPopover = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "geoIndexPatternSelect",
    fullWidth: true,
    error: errors.index
  }, /*#__PURE__*/_react.default.createElement(_geo_index_pattern_select.GeoIndexPatternSelect, {
    onChange: _indexPattern => {
      // reset time field and expression fields if indices are deleted
      if (!_indexPattern) {
        return;
      }
      setIndexPattern(_indexPattern);
    },
    value: indexPattern.id,
    IndexPatternSelectComponent: IndexPatternSelect,
    indexPatternService: data.indexPatterns,
    http: http,
    includedGeoTypes: _types.ES_GEO_FIELD_TYPES
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "containmentTimeField",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.geoContainment.timeFieldLabel",
      defaultMessage: "Time field"
    })
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.selectTimeLabel', {
      defaultMessage: 'Select time field'
    }),
    value: timeField,
    onChange: _timeField => _timeField && setAlertParamsDate(_timeField),
    fields: fields.current.dateFields
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "geoField",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.geofieldLabel', {
      defaultMessage: 'Geospatial field'
    })
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.selectGeoLabel', {
      defaultMessage: 'Select geo field'
    }),
    value: geoField,
    onChange: _geoField => _geoField && setAlertParamsGeoField(_geoField),
    fields: fields.current.geoFields
  })));
  return /*#__PURE__*/_react.default.createElement(_expression_with_popover.ExpressionWithPopover, {
    isInvalid: isInvalid,
    value: indexPattern.title,
    defaultValue: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.entityIndexSelect', {
      defaultMessage: 'Select a data view and geo point field'
    }),
    popoverContent: indexPopover,
    expressionDescription: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.entityIndexLabel', {
      defaultMessage: 'index'
    })
  });
};
exports.EntityIndexExpression = EntityIndexExpression;