"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BoundaryIndexExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _types = require("../../types");
var _geo_index_pattern_select = require("../util_components/geo_index_pattern_select");
var _single_field_select = require("../util_components/single_field_select");
var _expression_with_popover = require("../util_components/expression_with_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BoundaryIndexExpression = ({
  ruleParams,
  errors,
  boundaryIndexPattern,
  boundaryNameField,
  setBoundaryIndexPattern,
  setBoundaryGeoField,
  setBoundaryNameField,
  data,
  unifiedSearch
}) => {
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const BOUNDARY_NAME_ENTITY_TYPES = ['string', 'number', 'ip'];
  const {
    http
  } = (0, _public.useKibana)().services;
  const IndexPatternSelect = unifiedSearch.ui && unifiedSearch.ui.IndexPatternSelect || null;
  const {
    boundaryGeoField
  } = ruleParams;
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const nothingSelected = {
    name: '<nothing selected>',
    type: 'string'
  };
  const usePrevious = value => {
    const ref = (0, _react.useRef)();
    (0, _react.useEffect)(() => {
      ref.current = value;
    });
    return ref.current;
  };
  const oldIndexPattern = usePrevious(boundaryIndexPattern);
  const fields = (0, _react.useRef)({
    geoFields: [],
    boundaryNameFields: []
  });
  (0, _react.useEffect)(() => {
    if (oldIndexPattern !== boundaryIndexPattern) {
      var _boundaryIndexPattern;
      fields.current.geoFields = boundaryIndexPattern.fields && boundaryIndexPattern.fields.length && boundaryIndexPattern.fields.filter(field => _types.ES_GEO_SHAPE_TYPES.includes(field.type)) || [];
      if (fields.current.geoFields.length) {
        setBoundaryGeoField(fields.current.geoFields[0].name);
      }
      fields.current.boundaryNameFields = [...((_boundaryIndexPattern = boundaryIndexPattern.fields) !== null && _boundaryIndexPattern !== void 0 ? _boundaryIndexPattern : []).filter(field => {
        return BOUNDARY_NAME_ENTITY_TYPES.includes(field.type) && !field.name.startsWith('_') && !field.name.endsWith('keyword');
      }), nothingSelected];
      if (fields.current.boundaryNameFields.length) {
        setBoundaryNameField(fields.current.boundaryNameFields[0].name);
      }
    }
  }, [BOUNDARY_NAME_ENTITY_TYPES, boundaryIndexPattern, nothingSelected, oldIndexPattern, setBoundaryGeoField, setBoundaryNameField]);
  const indexPopover = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "geoIndexPatternSelect",
    fullWidth: true,
    error: errors.index
  }, /*#__PURE__*/_react.default.createElement(_geo_index_pattern_select.GeoIndexPatternSelect, {
    onChange: _indexPattern => {
      if (!_indexPattern) {
        return;
      }
      setBoundaryIndexPattern(_indexPattern);
    },
    value: boundaryIndexPattern.id,
    IndexPatternSelectComponent: IndexPatternSelect,
    indexPatternService: data.indexPatterns,
    http: http,
    includedGeoTypes: _types.ES_GEO_SHAPE_TYPES
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "geoField",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.geofieldLabel', {
      defaultMessage: 'Geospatial field'
    })
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.selectLabel', {
      defaultMessage: 'Select geo field'
    }),
    value: boundaryGeoField,
    onChange: setBoundaryGeoField,
    fields: fields.current.geoFields
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "boundaryNameFieldSelect",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.boundaryNameSelectLabel', {
      defaultMessage: 'Human-readable boundary name (optional)'
    })
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.boundaryNameSelect', {
      defaultMessage: 'Select boundary name'
    }),
    value: boundaryNameField || null,
    onChange: name => {
      setBoundaryNameField(name === nothingSelected.name ? undefined : name);
    },
    fields: fields.current.boundaryNameFields
  })));
  return /*#__PURE__*/_react.default.createElement(_expression_with_popover.ExpressionWithPopover, {
    defaultValue: 'Select a data view and geo shape field',
    value: boundaryIndexPattern.title,
    popoverContent: indexPopover,
    expressionDescription: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.indexLabel', {
      defaultMessage: 'index'
    })
  });
};
exports.BoundaryIndexExpression = BoundaryIndexExpression;