"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyRetentionSchedule = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../app_context");
var _components = require("../../../../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyRetentionSchedule = ({
  retentionSettings,
  onRetentionScheduleUpdated,
  isLoading,
  error
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const renderRetentionPanel = cronSchedule => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyRetentionSchedulePanel.retentionScheduleDescription",
    defaultMessage: "The cron schedule for retaining snapshots is: {cronSchedule}.",
    values: {
      cronSchedule: /*#__PURE__*/_react.default.createElement("strong", null, cronSchedule)
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.RetentionExecuteModalProvider, null, executeRetentionPrompt => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyRetentionSchedulePanel.retentionScheduleExecuteLinkTooltip",
        defaultMessage: "Run retention now"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "play",
      onClick: () => executeRetentionPrompt(),
      "aria-label": i18n.translate('xpack.snapshotRestore.policyRetentionSchedulePanel.retentionScheduleExecuteLinkAriaLabel', {
        defaultMessage: 'Run retention now'
      })
    }));
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.RetentionSettingsUpdateModalProvider, null, updateRetentionPrompt => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyRetentionSchedulePanel.retentionScheduleEditLinkTooltip",
        defaultMessage: "Edit retention schedule"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "pencil",
      onClick: () => updateRetentionPrompt(cronSchedule, onRetentionScheduleUpdated),
      "aria-label": i18n.translate('xpack.snapshotRestore.policyRetentionSchedulePanel.retentionScheduleEditLinkAriaLabel', {
        defaultMessage: 'Edit retention schedule'
      })
    }));
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  const renderRetentionNotConfiguredCallout = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyRetentionSchedulePanel.noScheduleConfiguredWarningTitle",
      defaultMessage: "Retention not scheduled"
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyRetentionSchedulePanel.noScheduleConfiguredWarningDescription",
    defaultMessage: "One or more policies have a retention period, but no retention is scheduled."
  })), /*#__PURE__*/_react.default.createElement(_components.RetentionExecuteModalProvider, null, executeRetentionPrompt => {
    return /*#__PURE__*/_react.default.createElement(_components.RetentionSettingsUpdateModalProvider, null, updateRetentionSettingsPrompt => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        id: "retentionActionMenu",
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          "data-test-subj": "retentionActionMenuButton",
          iconSide: "right",
          color: "warning",
          onClick: () => setIsPopoverOpen(!isPopoverOpen),
          iconType: "arrowDown"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyRetentionSchedulePanel.manageRetentionButtonLabel",
          defaultMessage: "Manage retention"
        })),
        isOpen: isPopoverOpen,
        closePopover: () => setIsPopoverOpen(false),
        panelPaddingSize: "none",
        anchorPosition: "rightUp",
        repositionOnScroll: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
        "data-test-subj": "retentionActionContextMenu",
        initialPanelId: 0,
        panels: [{
          id: 0,
          title: i18n.translate('xpack.snapshotRestore.policyRetentionSchedulePanel.managePanelTitle', {
            defaultMessage: 'Retention options'
          }),
          items: [{
            name: i18n.translate('xpack.snapshotRestore.policyRetentionSchedulePanel.executeButtonLabel', {
              defaultMessage: 'Run now'
            }),
            icon: 'play',
            onClick: () => executeRetentionPrompt()
          }, {
            name: i18n.translate('xpack.snapshotRestore.policyRetentionSchedulePanel.addButtonLabel', {
              defaultMessage: 'Schedule'
            }),
            icon: 'plusInCircle',
            onClick: () => updateRetentionSettingsPrompt(undefined, onRetentionScheduleUpdated)
          }]
        }]
      }));
    });
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyRetentionSchedulePanel.errorFetchingRetentionScheduleTitle",
        defaultMessage: "Error fetching retention schedule"
      }),
      color: "danger",
      iconType: "warning"
    }, error.data && error.data.message ? /*#__PURE__*/_react.default.createElement("p", null, error.data.message) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "refresh",
      color: "danger",
      onClick: onRetentionScheduleUpdated
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyRetentionSchedulePanel.errorFetchingRetentionScheduleReloadButtonLabel",
      defaultMessage: "Reload"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }
  if (retentionSettings && retentionSettings.retentionSchedule) {
    return renderRetentionPanel(retentionSettings.retentionSchedule);
  }
  return renderRetentionNotConfiguredCallout();
};
exports.PolicyRetentionSchedule = PolicyRetentionSchedule;