"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.S3Settings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("./common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const S3Settings = ({
  repository,
  updateRepositorySettings,
  settingErrors
}) => {
  const {
    settings: {
      bucket,
      client,
      basePath,
      compress,
      chunkSize,
      serverSideEncryption,
      bufferSize,
      cannedAcl,
      storageClass,
      maxRestoreBytesPerSec,
      maxSnapshotBytesPerSec,
      readonly
    }
  } = repository;
  const cannedAclOptions = ['private', 'public-read', 'public-read-write', 'authenticated-read', 'log-delivery-write', 'bucket-owner-read', 'bucket-owner-full-control'].map(option => ({
    value: option,
    text: option
  }));
  const hasErrors = Boolean(Object.keys(settingErrors).length);
  const updateSettings = (name, value) => {
    updateRepositorySettings({
      [name]: value
    });
  };
  const storageClassOptions = ['standard', 'reduced_redundancy', 'standard_ia', 'intelligent_tiering', 'onezone_ia'].map(option => ({
    value: option,
    text: option
  }));
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.clientTitle",
      defaultMessage: "Client"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.clientDescription",
      defaultMessage: "The name of the AWS S3 client."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.clientLabel",
      defaultMessage: "Client"
    }),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.client),
    error: settingErrors.client
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: client || '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        client: e.target.value
      });
    },
    "data-test-subj": "clientInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.bucketTitle",
      defaultMessage: "Bucket"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.bucketDescription",
      defaultMessage: "The name of the AWS S3 bucket to use for snapshots."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.bucketLabel",
      defaultMessage: "Bucket (required)"
    }),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.bucket),
    error: settingErrors.bucket
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: bucket || '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        bucket: e.target.value
      });
    },
    "data-test-subj": "bucketInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.basePathTitle",
      defaultMessage: "Base path"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.basePathDescription",
      defaultMessage: "The bucket path to the repository data."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.basePathLabel",
      defaultMessage: "Base path"
    }),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.basePath),
    error: settingErrors.basePath
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: basePath || '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        basePath: e.target.value
      });
    },
    "data-test-subj": "basePathInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.compressTitle",
      defaultMessage: "Snapshot compression"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.compressDescription",
      defaultMessage: "Compresses the index mapping and setting files for snapshots. Data files are not compressed."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.compress),
    error: settingErrors.compress
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.compressLabel",
      defaultMessage: "Compress snapshots"
    }),
    checked: !(compress === false),
    onChange: e => {
      updateRepositorySettings({
        compress: e.target.checked
      });
    },
    "data-test-subj": "compressToggle"
  }))), /*#__PURE__*/_react.default.createElement(_common.ChunkSizeField, {
    isInvalid: Boolean(hasErrors && settingErrors.chunkSize),
    error: settingErrors.chunkSize,
    defaultValue: chunkSize || '',
    updateSettings: updateSettings
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.serverSideEncryptionTitle",
      defaultMessage: "Server-side encryption"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.serverSideEncryptionDescription",
      defaultMessage: "Encrypts files on the server using AES256 algorithm."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.serverSideEncryption),
    error: settingErrors.serverSideEncryption
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.serverSideEncryptionLabel",
      defaultMessage: "Server-side encryption"
    }),
    checked: !!serverSideEncryption,
    onChange: e => {
      updateRepositorySettings({
        serverSideEncryption: e.target.checked
      });
    },
    "data-test-subj": "serverSideEncryptionToggle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.bufferSizeTitle",
      defaultMessage: "Buffer size"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.bufferSizeDescription",
      defaultMessage: "Beyond this minimum threshold, the S3 repository will use the AWS Multipart Upload API to split the chunk into several parts and upload each in its own request."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.bufferSizeLabel",
      defaultMessage: "Buffer size"
    }),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.bufferSize),
    error: settingErrors.bufferSize,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.bufferSizeHelpText",
      defaultMessage: "Accepts byte size units, such as {example1}, {example2}, {example3}, or {example4}. Defaults to {defaultSize} or {defaultPercentage} of JVM heap, whichever is smaller.",
      values: {
        example1: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "1g"),
        example2: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "10mb"),
        example3: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "5k"),
        example4: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "1024B"),
        defaultSize: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "100mb"),
        defaultPercentage: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "5%")
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: bufferSize || '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        bufferSize: e.target.value
      });
    },
    "data-test-subj": "bufferSizeInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.cannedAclTitle",
      defaultMessage: "Canned ACL"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.cannedAclDescription",
      defaultMessage: "The canned ACL to add to new S3 buckets and objects."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.cannedAclLabel",
      defaultMessage: "Canned ACL"
    }),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.cannedAcl),
    error: settingErrors.cannedAcl
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: cannedAclOptions,
    value: cannedAcl || cannedAclOptions[0].value,
    onChange: e => {
      updateRepositorySettings({
        cannedAcl: e.target.value
      });
    },
    fullWidth: true,
    "data-test-subj": "cannedAclSelect"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.storageClassTitle",
      defaultMessage: "Storage class"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.storageClassDescription",
      defaultMessage: "The storage class for new objects in the S3 repository."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.storageClassLabel",
      defaultMessage: "Storage class"
    }),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.storageClass),
    error: settingErrors.storageClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: storageClassOptions,
    value: storageClass || storageClassOptions[0].value,
    onChange: e => {
      updateRepositorySettings({
        storageClass: e.target.value
      });
    },
    fullWidth: true,
    "data-test-subj": "storageClassSelect"
  }))), /*#__PURE__*/_react.default.createElement(_common.MaxSnapshotsField, {
    isInvalid: Boolean(hasErrors && settingErrors.maxSnapshotBytesPerSec),
    error: settingErrors.maxSnapshotBytesPerSec,
    defaultValue: maxSnapshotBytesPerSec || '',
    updateSettings: updateSettings
  }), /*#__PURE__*/_react.default.createElement(_common.MaxRestoreField, {
    isInvalid: Boolean(hasErrors && settingErrors.maxRestoreBytesPerSec),
    error: settingErrors.maxRestoreBytesPerSec,
    defaultValue: maxRestoreBytesPerSec || '',
    updateSettings: updateSettings
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.readonlyTitle",
      defaultMessage: "Read-only"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.readonlyDescription",
      defaultMessage: "Only one cluster should have write access to this repository. All other clusters should be read-only."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.readonly),
    error: settingErrors.readonly
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeS3.readonlyLabel",
      defaultMessage: "Read-only repository"
    }),
    checked: !!readonly,
    onChange: e => {
      updateRepositorySettings({
        readonly: e.target.checked
      });
    },
    "data-test-subj": "readOnlyToggle"
  }))));
};
exports.S3Settings = S3Settings;