"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricCustomIndicatorTypeSchema = exports.metricCustomIndicatorSchema = exports.kqlCustomIndicatorTypeSchema = exports.kqlCustomIndicatorSchema = exports.indicatorTypesSchema = exports.indicatorTypesArraySchema = exports.indicatorSchema = exports.indicatorDataSchema = exports.apmTransactionErrorRateIndicatorTypeSchema = exports.apmTransactionErrorRateIndicatorSchema = exports.apmTransactionDurationIndicatorTypeSchema = exports.apmTransactionDurationIndicatorSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("./common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apmTransactionDurationIndicatorTypeSchema = t.literal('sli.apm.transactionDuration');
exports.apmTransactionDurationIndicatorTypeSchema = apmTransactionDurationIndicatorTypeSchema;
const apmTransactionDurationIndicatorSchema = t.type({
  type: apmTransactionDurationIndicatorTypeSchema,
  params: t.intersection([t.type({
    environment: _common.allOrAnyString,
    service: _common.allOrAnyString,
    transactionType: _common.allOrAnyString,
    transactionName: _common.allOrAnyString,
    threshold: t.number,
    index: t.string
  }), t.partial({
    filter: t.string
  })])
});
exports.apmTransactionDurationIndicatorSchema = apmTransactionDurationIndicatorSchema;
const apmTransactionErrorRateIndicatorTypeSchema = t.literal('sli.apm.transactionErrorRate');
exports.apmTransactionErrorRateIndicatorTypeSchema = apmTransactionErrorRateIndicatorTypeSchema;
const apmTransactionErrorRateIndicatorSchema = t.type({
  type: apmTransactionErrorRateIndicatorTypeSchema,
  params: t.intersection([t.type({
    environment: _common.allOrAnyString,
    service: _common.allOrAnyString,
    transactionType: _common.allOrAnyString,
    transactionName: _common.allOrAnyString,
    index: t.string
  }), t.partial({
    filter: t.string
  })])
});
exports.apmTransactionErrorRateIndicatorSchema = apmTransactionErrorRateIndicatorSchema;
const kqlCustomIndicatorTypeSchema = t.literal('sli.kql.custom');
exports.kqlCustomIndicatorTypeSchema = kqlCustomIndicatorTypeSchema;
const kqlCustomIndicatorSchema = t.type({
  type: kqlCustomIndicatorTypeSchema,
  params: t.type({
    index: t.string,
    filter: t.string,
    good: t.string,
    total: t.string,
    timestampField: t.string
  })
});
exports.kqlCustomIndicatorSchema = kqlCustomIndicatorSchema;
const metricCustomValidAggregations = t.keyof({
  sum: true
});
const metricCustomMetricDef = t.type({
  metrics: t.array(t.type({
    name: t.string,
    aggregation: metricCustomValidAggregations,
    field: t.string
  })),
  equation: t.string
});
const metricCustomIndicatorTypeSchema = t.literal('sli.metric.custom');
exports.metricCustomIndicatorTypeSchema = metricCustomIndicatorTypeSchema;
const metricCustomIndicatorSchema = t.type({
  type: metricCustomIndicatorTypeSchema,
  params: t.type({
    index: t.string,
    filter: t.string,
    good: metricCustomMetricDef,
    total: metricCustomMetricDef,
    timestampField: t.string
  })
});
exports.metricCustomIndicatorSchema = metricCustomIndicatorSchema;
const indicatorDataSchema = t.type({
  dateRange: _common.dateRangeSchema,
  good: t.number,
  total: t.number
});
exports.indicatorDataSchema = indicatorDataSchema;
const indicatorTypesSchema = t.union([apmTransactionDurationIndicatorTypeSchema, apmTransactionErrorRateIndicatorTypeSchema, kqlCustomIndicatorTypeSchema, metricCustomIndicatorTypeSchema]);

// Validate that a string is a comma separated list of indicator types,
// e.g. sli.kql.custom,sli.apm.transactionDuration
// Transform to an array of indicator type
exports.indicatorTypesSchema = indicatorTypesSchema;
const indicatorTypesArraySchema = new t.Type('indicatorTypesArray', input => Array.isArray(input) && input.every(i => typeof i === 'string'), (input, context) => {
  if (typeof input === 'string') {
    const values = input.split(',');
    if (values.every(value => typeof value === 'string' && indicatorTypesSchema.is(value))) {
      return t.success(values);
    }
  }
  return t.failure(input, context);
}, values => values.join(','));
exports.indicatorTypesArraySchema = indicatorTypesArraySchema;
const indicatorSchema = t.union([apmTransactionDurationIndicatorSchema, apmTransactionErrorRateIndicatorSchema, kqlCustomIndicatorSchema, metricCustomIndicatorSchema]);
exports.indicatorSchema = indicatorSchema;