"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.weightedAverageSourceSchema = exports.weightedAverageCompositeMethodSchema = exports.compositeSloSchema = exports.compositeSloIdSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("./common");
var _slo = require("./slo");
var _time_window = require("./time_window");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const compositeSloIdSchema = t.string;
exports.compositeSloIdSchema = compositeSloIdSchema;
const weightedAverageCompositeMethodSchema = t.literal('weightedAverage');
exports.weightedAverageCompositeMethodSchema = weightedAverageCompositeMethodSchema;
const weightedAverageSourceSchema = t.type({
  id: _slo.sloIdSchema,
  revision: t.number,
  weight: t.number
});
exports.weightedAverageSourceSchema = weightedAverageSourceSchema;
const compositeSloSchema = t.type({
  id: compositeSloIdSchema,
  name: t.string,
  timeWindow: _time_window.timeWindowSchema,
  budgetingMethod: _slo.budgetingMethodSchema,
  compositeMethod: weightedAverageCompositeMethodSchema,
  objective: _slo.objectiveSchema,
  sources: t.array(weightedAverageSourceSchema),
  tags: _slo.tagsSchema,
  createdAt: _common.dateType,
  updatedAt: _common.dateType
});
exports.compositeSloSchema = compositeSloSchema;