"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareContextMenu = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _url_panel_content = require("./url_panel_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ShareContextMenu extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "getPanels", () => {
      const panels = [];
      const menuItems = [];
      const permalinkPanel = {
        id: panels.length + 1,
        title: _i18n.i18n.translate('share.contextMenu.permalinkPanelTitle', {
          defaultMessage: 'Get link'
        }),
        content: /*#__PURE__*/_react.default.createElement(_url_panel_content.UrlPanelContent, {
          allowShortUrl: this.props.allowShortUrl,
          objectId: this.props.objectId,
          objectType: this.props.objectType,
          shareableUrl: this.props.shareableUrl,
          shareableUrlForSavedObject: this.props.shareableUrlForSavedObject,
          shareableUrlLocatorParams: this.props.shareableUrlLocatorParams,
          anonymousAccess: this.props.anonymousAccess,
          showPublicUrlSwitch: this.props.showPublicUrlSwitch,
          urlService: this.props.urlService,
          snapshotShareWarning: this.props.snapshotShareWarning
        })
      };
      menuItems.push({
        name: _i18n.i18n.translate('share.contextMenu.permalinksLabel', {
          defaultMessage: 'Get links'
        }),
        icon: 'link',
        panel: permalinkPanel.id,
        sortOrder: 0,
        disabled: Boolean(this.props.disabledShareUrl),
        // do not break functional tests
        'data-test-subj': 'Permalinks'
      });
      panels.push(permalinkPanel);
      if (this.props.allowEmbed) {
        const embedPanel = {
          id: panels.length + 1,
          title: _i18n.i18n.translate('share.contextMenu.embedCodePanelTitle', {
            defaultMessage: 'Embed Code'
          }),
          content: /*#__PURE__*/_react.default.createElement(_url_panel_content.UrlPanelContent, {
            allowShortUrl: this.props.allowShortUrl,
            isEmbedded: true,
            objectId: this.props.objectId,
            objectType: this.props.objectType,
            shareableUrl: this.props.shareableUrl,
            shareableUrlForSavedObject: this.props.shareableUrlForSavedObject,
            shareableUrlLocatorParams: this.props.shareableUrlLocatorParams,
            urlParamExtensions: this.props.embedUrlParamExtensions,
            anonymousAccess: this.props.anonymousAccess,
            showPublicUrlSwitch: this.props.showPublicUrlSwitch,
            urlService: this.props.urlService,
            snapshotShareWarning: this.props.snapshotShareWarning
          })
        };
        panels.push(embedPanel);
        menuItems.push({
          name: _i18n.i18n.translate('share.contextMenu.embedCodeLabel', {
            defaultMessage: 'Embed code'
          }),
          icon: 'console',
          panel: embedPanel.id,
          sortOrder: 0
        });
      }
      this.props.shareMenuItems.forEach(({
        shareMenuItem,
        panel
      }) => {
        const panelId = panels.length + 1;
        panels.push({
          ...panel,
          id: panelId
        });
        menuItems.push({
          ...shareMenuItem,
          panel: panelId
        });
      });
      if (menuItems.length > 1) {
        const topLevelMenuPanel = {
          id: panels.length + 1,
          title: _i18n.i18n.translate('share.contextMenuTitle', {
            defaultMessage: 'Share this {objectType}',
            values: {
              objectType: this.props.objectTypeTitle || this.props.objectType
            }
          }),
          items: menuItems
          // Sorts ascending on sort order first and then ascending on name
          .sort((a, b) => {
            const aSortOrder = a.sortOrder || 0;
            const bSortOrder = b.sortOrder || 0;
            if (aSortOrder > bSortOrder) {
              return 1;
            }
            if (aSortOrder < bSortOrder) {
              return -1;
            }
            if (a.name.toLowerCase().localeCompare(b.name.toLowerCase()) > 0) {
              return 1;
            }
            return -1;
          }).map(menuItem => {
            var _menuItem$dataTestS;
            menuItem['data-test-subj'] = `sharePanel-${(_menuItem$dataTestS = menuItem['data-test-subj']) !== null && _menuItem$dataTestS !== void 0 ? _menuItem$dataTestS : menuItem.name.replace(' ', '')}`;
            delete menuItem.sortOrder;
            return menuItem;
          })
        };
        panels.push(topLevelMenuPanel);
      }
      const lastPanelIndex = panels.length - 1;
      const initialPanelId = panels[lastPanelIndex].id;
      return {
        panels,
        initialPanelId
      };
    });
  }
  render() {
    const {
      panels,
      initialPanelId
    } = this.getPanels();
    return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: initialPanelId,
      panels: panels,
      "data-test-subj": "shareContextMenu"
    }));
  }
}
exports.ShareContextMenu = ShareContextMenu;