"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fs = require("fs");
var _path = require("path");
var _configSchema = require("@kbn/config-schema");
var _utils = require("@kbn/utils");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const switchBodySchema = _configSchema.schema.object({
  id: _configSchema.schema.oneOf([_configSchema.schema.literal('observability'), _configSchema.schema.literal('security'), _configSchema.schema.literal('search')])
});
const typeToIdMap = {
  observability: 'oblt',
  security: 'security',
  search: 'es'
};
class ServerlessPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.context = context;
    this.config = this.context.config.get();
  }
  setup(core) {
    var _developer$projectSwi;
    const router = core.http.createRouter();
    const {
      developer
    } = this.config;

    // If we're in development mode, and the switcher is enabled, register the
    // API endpoint responsible for switching projects.
    if (process.env.NODE_ENV !== 'production' && developer !== null && developer !== void 0 && (_developer$projectSwi = developer.projectSwitcher) !== null && _developer$projectSwi !== void 0 && _developer$projectSwi.enabled) {
      router.post({
        path: _common.API_SWITCH_PROJECT,
        validate: {
          body: switchBodySchema
        }
      }, async (_context, request, response) => {
        const {
          id
        } = request.body;
        const selectedProjectType = typeToIdMap[id];
        try {
          // The switcher is not enabled by default, in cases where one has started Serverless
          // with a specific config.  So in this case, to ensure the switcher remains enabled,
          // write the selected config to `recent` and tack on the setting to enable the switcher.
          (0, _fs.writeFileSync)((0, _path.resolve)((0, _utils.getConfigDirectory)(), 'serverless.recent.dev.yml'), `xpack.serverless.plugin.developer.projectSwitcher.enabled: true\nserverless: ${selectedProjectType}\n`);
          return response.ok({
            body: id
          });
        } catch (e) {
          return response.badRequest({
            body: e
          });
        }
      });
    }
    return {};
  }
  start(_core) {
    return {};
  }
  stop() {}
}
exports.ServerlessPlugin = ServerlessPlugin;