"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessSecurityPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _pli_features = require("../common/pli/pli_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessSecurityPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
  }
  setup(_coreSetup, pluginsSetup) {
    // essSecurity plugin should always be disabled when serverlessSecurity is enabled.
    // This check is an additional layer of security to prevent double registrations when
    // `plugins.forceEnableAllPlugins` flag is enabled).
    const shouldRegister = pluginsSetup.essSecurity == null;
    if (shouldRegister) {
      pluginsSetup.securitySolution.setAppFeatures((0, _pli_features.getProductAppFeatures)(this.config.productTypes));
    }
    return {};
  }
  start() {
    return {};
  }
  stop() {}
}
exports.ServerlessSecurityPlugin = ServerlessSecurityPlugin;