"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TogglePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _types = require("./types");
var i18n = _interopRequireWildcard(require("./translations"));
var _product_switch = require("./product_switch");
var _use_setup_cards = require("./use_setup_cards");
var _storage = require("../../lib/get_started/storage");
var _reducer = require("./reducer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TogglePanelComponent = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const shadow = (0, _eui.useEuiShadow)('s');
  const {
    getAllFinishedStepsFromStorage,
    getActiveProductsFromStorage,
    toggleActiveProductsInStorage,
    addFinishedStepToStorage
  } = _storage.getStartedStorage;
  const finishedStepsInitialStates = (0, _react.useMemo)(() => (0, _reducer.getFinishedStepsInitialStates)({
    finishedSteps: getAllFinishedStepsFromStorage()
  }), [getAllFinishedStepsFromStorage]);
  const activeSectionsInitialStates = (0, _react.useMemo)(() => (0, _reducer.getActiveSectionsInitialStates)({
    activeProducts: getActiveProductsFromStorage()
  }), [getActiveProductsFromStorage]);
  const activeCardsInitialStates = (0, _react.useMemo)(() => (0, _reducer.getActiveCardsInitialStates)({
    activeProducts: activeSectionsInitialStates,
    finishedSteps: finishedStepsInitialStates
  }), [activeSectionsInitialStates, finishedStepsInitialStates]);
  const [state, dispatch] = (0, _react.useReducer)(_reducer.reducer, {
    activeProducts: activeSectionsInitialStates,
    finishedSteps: finishedStepsInitialStates,
    activeCards: activeCardsInitialStates
  });
  const {
    setUpSections
  } = (0, _use_setup_cards.useSetUpCardSections)({
    euiTheme,
    shadow
  });
  const onStepClicked = (0, _react.useCallback)(({
    stepId,
    cardId,
    sectionId
  }) => {
    dispatch({
      type: _types.GetStartedPageActions.AddFinishedStep,
      payload: {
        stepId,
        cardId,
        sectionId
      }
    });
    addFinishedStepToStorage(cardId, stepId);
  }, [addFinishedStepToStorage]);
  const sectionNodes = setUpSections({
    onStepClicked,
    finishedSteps: state.finishedSteps,
    activeCards: state.activeCards
  });
  const onProductSwitchChanged = (0, _react.useCallback)(section => {
    dispatch({
      type: _types.GetStartedPageActions.ToggleProduct,
      payload: {
        section: section.id
      }
    });
    toggleActiveProductsInStorage(section.id);
  }, [toggleActiveProductsInStorage]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_product_switch.ProductSwitch, {
    onProductSwitchChanged: onProductSwitchChanged,
    activeProducts: state.activeProducts,
    euiTheme: euiTheme,
    shadow: shadow
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
          padding: ${euiTheme.size.xs} ${euiTheme.base * 2.25}px;
        `,
    grow: 1
  }, state.activeProducts.size > 0 ? sectionNodes : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "magnifyWithExclamation",
    title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.TOGGLE_PANEL_EMPTY_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, i18n.TOGGLE_PANEL_EMPTY_DESCRIPTION),
    css: (0, _react2.css)`
              padding: ${euiTheme.base * 5}px 0;
              .euiEmptyPrompt__contentInner {
                max-width: none;
              }
            `
  })));
};
const TogglePanel = /*#__PURE__*/_react.default.memo(TogglePanelComponent);
exports.TogglePanel = TogglePanel;