"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductSwitch = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("./types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const switches = [{
  id: _types.ProductId.analytics,
  label: i18n.ANALYTICS_SWITCH_LABEL
}, {
  id: _types.ProductId.cloud,
  label: i18n.CLOUD_SWITCH_LABEL
}, {
  id: _types.ProductId.endpoint,
  label: i18n.ENDPOINT_SWITCH_LABEL
}];
const ProductSwitchComponent = ({
  onProductSwitchChanged,
  activeProducts,
  euiTheme,
  shadow = ''
}) => {
  const switchNodes = (0, _react2.useMemo)(() => switches.map(item => /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
    key: item.id,
    "data-test-subj": item.id,
    label: item.label,
    onChange: () => onProductSwitchChanged(item),
    css: (0, _react.css)`
            padding-left: ${euiTheme.base * 0.625}px;
          `,
    checked: activeProducts.has(item.id)
  })), [activeProducts, euiTheme.base, onProductSwitchChanged]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "product-switch",
    color: "plain",
    element: "div",
    grow: false,
    paddingSize: "none",
    hasShadow: false,
    css: (0, _react.css)`
        padding: ${euiTheme.base * 1.25}px ${euiTheme.base * 2.25}px;
        ${shadow};
      `,
    borderRadius: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: (0, _react.css)`
          padding-right: ${euiTheme.size.xs};
        `
  }, /*#__PURE__*/_react2.default.createElement("strong", null, i18n.TOGGLE_PANEL_TITLE)), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-displayInline"
  }, switchNodes));
};
ProductSwitchComponent.displayName = 'ProductSwitchComponent';
const ProductSwitch = ProductSwitchComponent;
exports.ProductSwitch = ProductSwitch;