"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessSearchPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _api_key_routes = require("./routes/api_key_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessSearchPlugin {
  // @ts-ignore config is not used for now

  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "security", void 0);
    this.config = initializerContext.config.get();
    this.logger = initializerContext.logger.get();
  }
  setup({
    getStartServices,
    http
  }) {
    const router = http.createRouter();
    getStartServices().then(([, {
      security
    }]) => {
      this.security = security;
      const dependencies = {
        logger: this.logger,
        router,
        security: this.security
      };
      (0, _api_key_routes.registerApiKeyRoutes)(dependencies);
    });
    return {};
  }
  start() {
    return {};
  }
  stop() {}
}
exports.ServerlessSearchPlugin = ServerlessSearchPlugin;