"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createServerlessSearchSideNavComponent = void 0;
var _sharedUxChromeNavigation = require("@kbn/shared-ux-chrome-navigation");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const navigationTree = {
  body: [{
    type: 'recentlyAccessed'
  }, {
    type: 'navGroup',
    id: 'search_project_nav',
    title: 'Elasticsearch',
    icon: 'logoElasticsearch',
    defaultIsCollapsed: false,
    children: [{
      id: 'search_getting_started',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.gettingStarted', {
        defaultMessage: 'Getting started'
      }),
      link: 'serverlessElasticsearch'
    }, {
      id: 'dev_tools',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.devTools', {
        defaultMessage: 'Dev Tools'
      }),
      children: (0, _sharedUxChromeNavigation.getPresets)('devtools').children[0].children
    }, {
      id: 'explore',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.explore', {
        defaultMessage: 'Explore'
      }),
      children: [{
        link: 'discover'
      }, {
        link: 'dashboards'
      }, {
        link: 'visualize'
      }]
    }, {
      id: 'content',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.content', {
        defaultMessage: 'Content'
      }),
      children: [{
        title: _i18n.i18n.translate('xpack.serverlessSearch.nav.content.indices', {
          defaultMessage: 'Indices'
        }),
        // TODO: this will be updated to a new Indices page
        link: 'management:index_management'
      }, {
        title: _i18n.i18n.translate('xpack.serverlessSearch.nav.content.transforms', {
          defaultMessage: 'Transforms'
        }),
        // TODO: this will be updated to a new Transforms page
        link: 'management:ingest_pipelines'
      }, {
        id: 'content_indexing_api',
        title: _i18n.i18n.translate('xpack.serverlessSearch.nav.content.indexingApi', {
          defaultMessage: 'Indexing API'
        }),
        // TODO: this page does not exist yet, linking to getting started for now
        link: 'serverlessElasticsearch'
      }]
    }, {
      id: 'security',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.security', {
        defaultMessage: 'Security'
      }),
      children: [{
        link: 'management:api_keys'
      }]
    }]
  }]
};
const createServerlessSearchSideNavComponent = (core, {
  serverless
}) => () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxChromeNavigation.NavigationKibanaProvider, {
    core: core,
    serverless: serverless
  }, /*#__PURE__*/_react.default.createElement(_sharedUxChromeNavigation.DefaultNavigation, {
    navigationTree: navigationTree,
    dataTestSubj: "svlSearchSideNav"
  }));
};
exports.createServerlessSearchSideNavComponent = createServerlessSearchSideNavComponent;