"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LanguageClientPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("../../../../common");
var _use_kibana = require("../../hooks/use_kibana");
require("./select_client.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LanguageClientPanel = ({
  language,
  setSelectedLanguage,
  isSelectedLanguage
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    borderRadius: "m",
    className: isSelectedLanguage ? 'serverlessSearchSelectClientPanelSelectedBorder' : 'serverlessSearchSelectClientPanelBorder',
    onClick: () => setSelectedLanguage(language),
    color: isSelectedLanguage ? 'primary' : 'plain'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: "",
    src: http.basePath.prepend(`/plugins/${_common.PLUGIN_ID}/assets/${language.iconType}`),
    height: euiTheme.size.xl,
    width: euiTheme.size.xl
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    color: isSelectedLanguage ? 'default' : 'subdued'
  }, /*#__PURE__*/_react.default.createElement("h5", null, language.name)))))));
};
exports.LanguageClientPanel = LanguageClientPanel;