"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallClientPanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _code_box = require("../code_box");
var _languages = require("../languages/languages");
var _overview_panel = require("./overview_panel");
var _types = require("../languages/types");
var _github_link = require("../shared/github_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Link = ({
  language
}) => {
  switch (language) {
    case _types.Languages.CURL:
      return /*#__PURE__*/_react.default.createElement(_github_link.GithubLink, {
        href: "https://github.com/curl/curl",
        label: _i18n.i18n.translate('xpack.serverlessSearch.githubLink.curl.label', {
          defaultMessage: 'curl'
        })
      });
    case _types.Languages.JAVASCRIPT:
      return /*#__PURE__*/_react.default.createElement(_github_link.GithubLink, {
        href: "https://github.com/elastic/elasticsearch-js",
        label: _i18n.i18n.translate('xpack.serverlessSearch.githubLink.javascript.label', {
          defaultMessage: 'elasticsearch'
        })
      });
    case _types.Languages.RUBY:
      return /*#__PURE__*/_react.default.createElement(_github_link.GithubLink, {
        href: "https://github.com/elastic/elasticsearch-ruby",
        label: _i18n.i18n.translate('xpack.serverlessSearch.githubLink.ruby.label', {
          defaultMessage: 'elasticsearch-ruby'
        })
      });
  }
  return null;
};
const InstallClientPanel = ({
  codeArguments,
  language,
  setSelectedLanguage
}) => {
  return /*#__PURE__*/_react.default.createElement(_overview_panel.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.serverlessSearch.installClient.description', {
      defaultMessage: 'Elastic builds and maintains clients in several popular languages and our community has contributed many more. Install your favorite language client to get started.'
    }),
    links: [{
      href: language.docLink,
      label: _i18n.i18n.translate('xpack.serverlessSearch.installClient.clientDocLink', {
        defaultMessage: '{languageName} client documentation',
        values: {
          languageName: language.name
        }
      })
    }],
    title: _i18n.i18n.translate('xpack.serverlessSearch.installClient.title', {
      defaultMessage: 'Install a client'
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_code_box.CodeBox, {
      code: "installClient",
      codeArgs: codeArguments,
      languageType: "shell",
      languages: _languages.languageDefinitions,
      selectedLanguage: language,
      setSelectedLanguage: setSelectedLanguage
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(Link, {
      language: language.id
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "iInCircle",
      title: _i18n.i18n.translate('xpack.serverlessSearch.apiCallOut.title', {
        defaultMessage: 'Call the API with Console'
      }),
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.serverlessSearch.apiCallout.content', {
      defaultMessage: 'Console enables you to call Elasticsearch and Kibana REST APIs directly, without needing to install a language client.'
    }))))
  });
};
exports.InstallClientPanel = InstallClientPanel;