"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeBox = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../common");
var _use_kibana = require("../hooks/use_kibana");
var _console = require("./languages/console");
var _try_in_console_button = require("./try_in_console_button");
require("./code_box.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCodeSnippet = (language, key, args) => {
  const snippetVal = language[key];
  if (snippetVal === undefined) return '';
  if (typeof snippetVal === 'string') return snippetVal;
  return snippetVal(args);
};
const CodeBox = ({
  code,
  codeArgs,
  languages,
  languageType,
  selectedLanguage,
  setSelectedLanguage
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const items = languages.map(language => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: language.id,
    icon: http.basePath.prepend(`/plugins/${_common.PLUGIN_ID}/assets/${language.iconType}`),
    onClick: () => {
      setSelectedLanguage(language);
      setIsPopoverOpen(false);
    }
  }, language.name));
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.serverlessSearch.codeBox.selectAriaLabel', {
      defaultMessage: 'Select a programming language'
    }),
    color: "text",
    iconType: "arrowDown",
    iconSide: "left",
    onClick: () => setIsPopoverOpen(!isPopoverOpen)
  }, selectedLanguage.name));
  const codeSnippet = getCodeSnippet(selectedLanguage, code, codeArgs);
  const showTryInConsole = (code in _console.consoleDefinition);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xs",
    className: "serverlessSearchCodeBlockControlsPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "light"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: codeSnippet
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    iconType: "copy",
    size: "s",
    onClick: copy
  }, _i18n.i18n.translate('xpack.serverlessSearch.codeBox.copyButtonLabel', {
    defaultMessage: 'Copy'
  })))), showTryInConsole && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_try_in_console_button.TryInConsoleButton, {
    request: getCodeSnippet(_console.consoleDefinition, code, codeArgs)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    transparentBackground: true,
    fontSize: "m",
    language: languageType || selectedLanguage.languageStyling || selectedLanguage.id
  }, codeSnippet)));
};
exports.CodeBox = CodeBox;