"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getObservabilitySideNavComponent = void 0;
var _sharedUxChromeNavigation = require("@kbn/shared-ux-chrome-navigation");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const navigationTree = {
  body: [{
    type: 'recentlyAccessed'
  }, {
    type: 'navGroup',
    id: 'observability_project_nav',
    title: 'Observability',
    icon: 'logoObservability',
    defaultIsCollapsed: false,
    children: [{
      id: 'services-infra',
      children: [{
        link: 'apm:services'
      }, {
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.infrastructure', {
          defaultMessage: 'Infrastructure'
        }),
        link: 'metrics:inventory'
      }]
    }, {
      id: 'alerts-cases-slos',
      children: [{
        link: 'observability-overview:alerts'
      }, {
        link: 'observability-overview:cases'
      }, {
        link: 'observability-overview:slos'
      }]
    }, {
      id: 'signals',
      title: 'Signals',
      children: [{
        link: 'apm:traces'
      }, {
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.signalsLogs', {
          defaultMessage: 'Logs'
        }),
        link: 'logs:stream'
      }]
    }, {
      id: 'toolbox',
      title: 'Toolbox',
      children: [{
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.toolBoxVisualization', {
          defaultMessage: 'Visualization'
        }),
        link: 'visualize'
      }, {
        link: 'dashboards'
      }]
    }, {
      id: 'on-boarding',
      children: [{
        title: _i18n.i18n.translate('xpack.serverlessObservability.nav.getStarted', {
          defaultMessage: 'Get started'
        }),
        icon: 'launch',
        link: 'observabilityOnboarding'
      }]
    }]
  }, {
    type: 'navGroup',
    ...(0, _sharedUxChromeNavigation.getPresets)('analytics')
  }, {
    type: 'navGroup',
    ...(0, _sharedUxChromeNavigation.getPresets)('ml')
  }],
  footer: [{
    type: 'navGroup',
    ...(0, _sharedUxChromeNavigation.getPresets)('management')
  }]
};
const getObservabilitySideNavComponent = (core, {
  serverless
}) => () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxChromeNavigation.NavigationKibanaProvider, {
    core: core,
    serverless: serverless
  }, /*#__PURE__*/_react.default.createElement(_sharedUxChromeNavigation.DefaultNavigation, {
    navigationTree: navigationTree,
    dataTestSubj: "svlObservabilitySideNav"
  }));
};
exports.getObservabilitySideNavComponent = getObservabilitySideNavComponent;