"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseEndpoint = parseEndpoint;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function parseEndpoint(endpoint) {
  var _parts$;
  const parts = endpoint.split(' ');
  const method = parts[0].trim().toLowerCase();
  const pathname = parts[1].trim();
  const version = (_parts$ = parts[2]) === null || _parts$ === void 0 ? void 0 : _parts$.trim();
  if (!['get', 'post', 'put', 'delete'].includes(method)) {
    throw new Error(`Endpoint ${endpoint} was not prefixed with a valid HTTP method`);
  }
  if (!version && pathname.startsWith('/api')) {
    throw new Error(`Missing version for public endpoint ${endpoint}`);
  }
  return {
    method,
    pathname,
    version
  };
}