"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_EXCEPTION_LIST_SIZE = exports.MAXIMUM_SMALL_VALUE_LIST_SIZE = exports.MAXIMUM_SMALL_IP_RANGE_VALUE_LIST_DASH_SIZE = exports.LIST_URL = exports.LIST_PRIVILEGES_URL = exports.LIST_ITEM_URL = exports.LIST_INDEX = exports.INTERNAL_LIST_URL = exports.INTERNAL_EXCEPTION_LIST_URL = exports.INTERNAL_EXCEPTIONS_LIST_ENSURE_CREATED_URL = exports.FIND_LISTS_BY_SIZE = exports.EXCEPTION_LIST_URL = exports.EXCEPTION_LIST_NAMESPACE_AGNOSTIC = exports.EXCEPTION_LIST_NAMESPACE = exports.EXCEPTION_LIST_ITEM_URL = exports.EXCEPTION_FILTER = exports.ENDPOINT_TRUSTED_APPS_LIST_NAME = exports.ENDPOINT_TRUSTED_APPS_LIST_ID = exports.ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = exports.ENDPOINT_LIST_URL = exports.ENDPOINT_LIST_NAME = exports.ENDPOINT_LIST_ITEM_URL = exports.ENDPOINT_LIST_ID = exports.ENDPOINT_LIST_DESCRIPTION = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = exports.ENDPOINT_EVENT_FILTERS_LIST_NAME = exports.ENDPOINT_EVENT_FILTERS_LIST_ID = exports.ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = exports.ENDPOINT_BLOCKLISTS_LIST_NAME = exports.ENDPOINT_BLOCKLISTS_LIST_ID = exports.ENDPOINT_BLOCKLISTS_LIST_DESCRIPTION = exports.ENDPOINT_ARTIFACT_LIST_IDS = exports.ENDPOINT_ARTIFACT_LISTS = void 0;
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Value list routes
 */
const LIST_URL = '/api/lists';
exports.LIST_URL = LIST_URL;
const LIST_INDEX = `${LIST_URL}/index`;
exports.LIST_INDEX = LIST_INDEX;
const LIST_ITEM_URL = `${LIST_URL}/items`;
exports.LIST_ITEM_URL = LIST_ITEM_URL;
const LIST_PRIVILEGES_URL = `${LIST_URL}/privileges`;

/**
 * Internal value list routes
 */
exports.LIST_PRIVILEGES_URL = LIST_PRIVILEGES_URL;
const INTERNAL_LIST_URL = '/internal/lists';
exports.INTERNAL_LIST_URL = INTERNAL_LIST_URL;
const FIND_LISTS_BY_SIZE = `${INTERNAL_LIST_URL}/_find_lists_by_size`;
exports.FIND_LISTS_BY_SIZE = FIND_LISTS_BY_SIZE;
const EXCEPTION_FILTER = `${INTERNAL_LIST_URL}/_create_filter`;

/**
 * Exception list routes
 */
exports.EXCEPTION_FILTER = EXCEPTION_FILTER;
const EXCEPTION_LIST_URL = '/api/exception_lists';
exports.EXCEPTION_LIST_URL = EXCEPTION_LIST_URL;
const EXCEPTION_LIST_ITEM_URL = '/api/exception_lists/items';

/**
 * Internal exception list routes
 */
exports.EXCEPTION_LIST_ITEM_URL = EXCEPTION_LIST_ITEM_URL;
const INTERNAL_EXCEPTION_LIST_URL = `/internal${EXCEPTION_LIST_URL}`;
exports.INTERNAL_EXCEPTION_LIST_URL = INTERNAL_EXCEPTION_LIST_URL;
const INTERNAL_EXCEPTIONS_LIST_ENSURE_CREATED_URL = `${INTERNAL_EXCEPTION_LIST_URL}/_create`;

/**
 * Exception list spaces
 */
exports.INTERNAL_EXCEPTIONS_LIST_ENSURE_CREATED_URL = INTERNAL_EXCEPTIONS_LIST_ENSURE_CREATED_URL;
const EXCEPTION_LIST_NAMESPACE_AGNOSTIC = 'exception-list-agnostic';
exports.EXCEPTION_LIST_NAMESPACE_AGNOSTIC = EXCEPTION_LIST_NAMESPACE_AGNOSTIC;
const EXCEPTION_LIST_NAMESPACE = 'exception-list';

/**
 * Specific routes for the single global space agnostic endpoint list
 */
exports.EXCEPTION_LIST_NAMESPACE = EXCEPTION_LIST_NAMESPACE;
const ENDPOINT_LIST_URL = '/api/endpoint_list';

/**
 * Specific routes for the single global space agnostic endpoint list. These are convenience
 * routes where they are going to try and create the global space agnostic endpoint list if it
 * does not exist yet or if it was deleted at some point and re-create it before adding items to
 * the list
 */
exports.ENDPOINT_LIST_URL = ENDPOINT_LIST_URL;
const ENDPOINT_LIST_ITEM_URL = '/api/endpoint_list/items';

/**
 * This ID is used for _both_ the Saved Object ID and for the list_id
 * for the single global space agnostic endpoint list
 */
exports.ENDPOINT_LIST_ITEM_URL = ENDPOINT_LIST_ITEM_URL;
const ENDPOINT_LIST_ID = 'endpoint_list';

/** The name of the single global space agnostic endpoint list */
exports.ENDPOINT_LIST_ID = ENDPOINT_LIST_ID;
const ENDPOINT_LIST_NAME = 'Endpoint Security Exception List';

/** The description of the single global space agnostic endpoint list */
exports.ENDPOINT_LIST_NAME = ENDPOINT_LIST_NAME;
const ENDPOINT_LIST_DESCRIPTION = 'Endpoint Security Exception List';
exports.ENDPOINT_LIST_DESCRIPTION = ENDPOINT_LIST_DESCRIPTION;
const MAX_EXCEPTION_LIST_SIZE = 10000;
exports.MAX_EXCEPTION_LIST_SIZE = MAX_EXCEPTION_LIST_SIZE;
const MAXIMUM_SMALL_VALUE_LIST_SIZE = 65536;
exports.MAXIMUM_SMALL_VALUE_LIST_SIZE = MAXIMUM_SMALL_VALUE_LIST_SIZE;
const MAXIMUM_SMALL_IP_RANGE_VALUE_LIST_DASH_SIZE = 200;

/**
 * List definitions for Endpoint Artifact
 */
exports.MAXIMUM_SMALL_IP_RANGE_VALUE_LIST_DASH_SIZE = MAXIMUM_SMALL_IP_RANGE_VALUE_LIST_DASH_SIZE;
const ENDPOINT_ARTIFACT_LISTS = (0, _std.deepFreeze)({
  trustedApps: {
    id: 'endpoint_trusted_apps',
    name: 'Endpoint Security Trusted Apps List',
    description: 'Endpoint Security Trusted Apps List'
  },
  eventFilters: {
    id: 'endpoint_event_filters',
    name: 'Endpoint Security Event Filters List',
    description: 'Endpoint Security Event Filters List'
  },
  hostIsolationExceptions: {
    id: 'endpoint_host_isolation_exceptions',
    name: 'Endpoint Security Host isolation exceptions List',
    description: 'Endpoint Security Host isolation exceptions List'
  },
  blocklists: {
    id: 'endpoint_blocklists',
    name: 'Endpoint Security Blocklists List',
    description: 'Endpoint Security Blocklists List'
  }
});

/**
 * The IDs of all Endpoint artifact lists
 */
exports.ENDPOINT_ARTIFACT_LISTS = ENDPOINT_ARTIFACT_LISTS;
const ENDPOINT_ARTIFACT_LIST_IDS = Object.freeze(Object.values(ENDPOINT_ARTIFACT_LISTS).map(({
  id
}) => id));

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_ARTIFACT_LIST_IDS = ENDPOINT_ARTIFACT_LIST_IDS;
const ENDPOINT_TRUSTED_APPS_LIST_ID = ENDPOINT_ARTIFACT_LISTS.trustedApps.id;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_TRUSTED_APPS_LIST_ID = ENDPOINT_TRUSTED_APPS_LIST_ID;
const ENDPOINT_TRUSTED_APPS_LIST_NAME = ENDPOINT_ARTIFACT_LISTS.trustedApps.name;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_TRUSTED_APPS_LIST_NAME = ENDPOINT_TRUSTED_APPS_LIST_NAME;
const ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = ENDPOINT_ARTIFACT_LISTS.trustedApps.description;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION;
const ENDPOINT_EVENT_FILTERS_LIST_ID = ENDPOINT_ARTIFACT_LISTS.eventFilters.id;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_EVENT_FILTERS_LIST_ID = ENDPOINT_EVENT_FILTERS_LIST_ID;
const ENDPOINT_EVENT_FILTERS_LIST_NAME = ENDPOINT_ARTIFACT_LISTS.eventFilters.name;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_EVENT_FILTERS_LIST_NAME = ENDPOINT_EVENT_FILTERS_LIST_NAME;
const ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = ENDPOINT_ARTIFACT_LISTS.eventFilters.description;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION;
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = ENDPOINT_ARTIFACT_LISTS.hostIsolationExceptions.id;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID;
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = ENDPOINT_ARTIFACT_LISTS.hostIsolationExceptions.name;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME;
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = ENDPOINT_ARTIFACT_LISTS.hostIsolationExceptions.description;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION;
const ENDPOINT_BLOCKLISTS_LIST_ID = ENDPOINT_ARTIFACT_LISTS.blocklists.id;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_BLOCKLISTS_LIST_ID = ENDPOINT_BLOCKLISTS_LIST_ID;
const ENDPOINT_BLOCKLISTS_LIST_NAME = ENDPOINT_ARTIFACT_LISTS.blocklists.name;

/** @deprecated Use `ENDPOINT_ARTIFACT_LISTS` instead */
exports.ENDPOINT_BLOCKLISTS_LIST_NAME = ENDPOINT_BLOCKLISTS_LIST_NAME;
const ENDPOINT_BLOCKLISTS_LIST_DESCRIPTION = ENDPOINT_ARTIFACT_LISTS.blocklists.description;
exports.ENDPOINT_BLOCKLISTS_LIST_DESCRIPTION = ENDPOINT_BLOCKLISTS_LIST_DESCRIPTION;