"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hostsRelatedUsers = void 0;
var _fp = require("lodash/fp");
var _build_query = require("../../../../../utils/build_query");
var _queryRelated_users = require("./query.related_users.dsl");
var _all = require("../../users/all");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hostsRelatedUsers = {
  buildDsl: options => (0, _queryRelated_users.buildRelatedUsersQuery)(options),
  parse: async (options, response, deps) => {
    const aggregations = response.rawResponse.aggregations;
    const inspect = {
      dsl: [(0, _build_query.inspectStringifyObject)((0, _queryRelated_users.buildRelatedUsersQuery)(options))]
    };
    if (aggregations == null) {
      return {
        ...response,
        inspect,
        totalCount: 0,
        relatedUsers: []
      };
    }
    const totalCount = (0, _fp.getOr)(0, 'aggregations.user_count.value', response.rawResponse);
    const buckets = (0, _fp.getOr)([], 'aggregations.user_data.buckets', response.rawResponse);
    const relatedUsers = buckets.map(bucket => {
      var _bucket$ip$buckets$ma, _bucket$ip;
      return {
        user: bucket.key,
        ip: (_bucket$ip$buckets$ma = (_bucket$ip = bucket.ip) === null || _bucket$ip === void 0 ? void 0 : _bucket$ip.buckets.map(ip => ip.key)) !== null && _bucket$ip$buckets$ma !== void 0 ? _bucket$ip$buckets$ma : []
      };
    }, {});
    const enhancedUsers = deps !== null && deps !== void 0 && deps.spaceId ? await addUserRiskData(relatedUsers, deps.spaceId, deps.esClient) : relatedUsers;
    return {
      ...response,
      inspect,
      totalCount,
      relatedUsers: enhancedUsers
    };
  }
};
exports.hostsRelatedUsers = hostsRelatedUsers;
async function addUserRiskData(relatedUsers, spaceId, esClient) {
  const userNames = relatedUsers.map(item => item.user);
  const userRiskData = await (0, _all.getUserRiskData)(esClient, spaceId, userNames);
  const usersRiskByUserName = userRiskData === null || userRiskData === void 0 ? void 0 : userRiskData.hits.hits.reduce((acc, hit) => {
    var _hit$_source$user$nam, _hit$_source, _hit$_source2, _hit$_source2$user, _hit$_source2$user$ri;
    return {
      ...acc,
      [(_hit$_source$user$nam = (_hit$_source = hit._source) === null || _hit$_source === void 0 ? void 0 : _hit$_source.user.name) !== null && _hit$_source$user$nam !== void 0 ? _hit$_source$user$nam : '']: (_hit$_source2 = hit._source) === null || _hit$_source2 === void 0 ? void 0 : (_hit$_source2$user = _hit$_source2.user) === null || _hit$_source2$user === void 0 ? void 0 : (_hit$_source2$user$ri = _hit$_source2$user.risk) === null || _hit$_source2$user$ri === void 0 ? void 0 : _hit$_source2$user$ri.calculated_level
    };
  }, {});
  return usersRiskByUserName ? relatedUsers.map(item => ({
    ...item,
    risk: usersRiskByUserName[item.user]
  })) : relatedUsers;
}