"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestContextFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _constants = require("../common/constants");
var _client = require("./client");
var _common = require("./lib/timeline/utils/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RequestContextFactory {
  constructor(options) {
    (0, _defineProperty2.default)(this, "appClientFactory", void 0);
    this.options = options;
    this.appClientFactory = new _client.AppClientFactory();
  }
  async create(context, request) {
    var _startPlugins$spaces2, _startPlugins$spaces3;
    const {
      options,
      appClientFactory
    } = this;
    const {
      config,
      core,
      plugins,
      endpointAppContextService,
      ruleMonitoringService,
      riskEngineDataClient
    } = options;
    const {
      lists,
      ruleRegistry,
      security
    } = plugins;
    const [, startPlugins] = await core.getStartServices();
    const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, security, request);
    const coreContext = await context.core;
    const getSpaceId = () => {
      var _startPlugins$spaces, _startPlugins$spaces$;
      return ((_startPlugins$spaces = startPlugins.spaces) === null || _startPlugins$spaces === void 0 ? void 0 : (_startPlugins$spaces$ = _startPlugins$spaces.spacesService) === null || _startPlugins$spaces$ === void 0 ? void 0 : _startPlugins$spaces$.getSpaceId(request)) || _constants.DEFAULT_SPACE_ID;
    };
    appClientFactory.setup({
      getSpaceId: (_startPlugins$spaces2 = startPlugins.spaces) === null || _startPlugins$spaces2 === void 0 ? void 0 : (_startPlugins$spaces3 = _startPlugins$spaces2.spacesService) === null || _startPlugins$spaces3 === void 0 ? void 0 : _startPlugins$spaces3.getSpaceId,
      config,
      kibanaVersion: options.kibanaVersion,
      kibanaBranch: options.kibanaBranch
    });

    // List of endpoint authz for the current request's user. Will be initialized the first
    // time it is requested (see `getEndpointAuthz()` below)
    let endpointAuthz;
    return {
      core: coreContext,
      getServerBasePath: () => core.http.basePath.serverBasePath,
      getEndpointAuthz: async () => {
        if (!endpointAuthz) {
          // eslint-disable-next-line require-atomic-updates
          endpointAuthz = await endpointAppContextService.getEndpointAuthz(request);
        }
        return endpointAuthz;
      },
      getConfig: () => config,
      getFrameworkRequest: () => frameworkRequest,
      getAppClient: () => appClientFactory.create(request),
      getSpaceId,
      getRuleDataService: () => ruleRegistry.ruleDataService,
      getRacClient: startPlugins.ruleRegistry.getRacClientWithRequest,
      getDetectionEngineHealthClient: (0, _lodash.memoize)(() => ruleMonitoringService.createDetectionEngineHealthClient({
        rulesClient: startPlugins.alerting.getRulesClientWithRequest(request),
        eventLogClient: startPlugins.eventLog.getClient(request),
        currentSpaceId: getSpaceId()
      })),
      getRuleExecutionLog: (0, _lodash.memoize)(() => ruleMonitoringService.createRuleExecutionLogClientForRoutes({
        savedObjectsClient: coreContext.savedObjects.client,
        eventLogClient: startPlugins.eventLog.getClient(request)
      })),
      getExceptionListClient: () => {
        var _security$authc$getCu;
        if (!lists) {
          return null;
        }
        const username = (security === null || security === void 0 ? void 0 : (_security$authc$getCu = security.authc.getCurrentUser(request)) === null || _security$authc$getCu === void 0 ? void 0 : _security$authc$getCu.username) || 'elastic';
        return lists.getExceptionListClient(coreContext.savedObjects.client, username);
      },
      getInternalFleetServices: (0, _lodash.memoize)(() => endpointAppContextService.getInternalFleetServices()),
      getRiskEngineDataClient: () => riskEngineDataClient
    };
  }
}
exports.RequestContextFactory = RequestContextFactory;