"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTagsByNameRoute = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../common/constants");
var _utils = require("../../detection_engine/routes/utils");
var _common = require("../../timeline/utils/common");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTagsParamsSchema = _configSchema.schema.object({
  name: _configSchema.schema.string()
});
const getTagsByNameRoute = (router, logger, security) => {
  router.get({
    path: _constants.INTERNAL_TAGS_URL,
    validate: {
      query: getTagsParamsSchema
    },
    options: {
      tags: ['access:securitySolution']
    }
  }, async (context, request, response) => {
    const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, security, request);
    const savedObjectsClient = (await frameworkRequest.context.core).savedObjects.client;
    const {
      name: tagName
    } = request.query;
    try {
      const tags = await (0, _saved_objects.findTagsByName)({
        savedObjectsClient,
        tagName
      });
      return response.ok({
        body: tags
      });
    } catch (err) {
      var _error$statusCode;
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      logger.error(`Failed to find ${tagName} tags - ${JSON.stringify(error.message)}`);
      const siemResponse = (0, _utils.buildSiemResponse)(response);
      return siemResponse.error({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: _i18n.i18n.translate('xpack.securitySolution.dashboards.getSecuritySolutionTagsErrorTitle', {
          values: {
            tagName,
            message: error.message
          },
          defaultMessage: `Failed to find {tagName} tags - {message}`
        })
      });
    }
  });
};
exports.getTagsByNameRoute = getTagsByNameRoute;