"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskScorePreviewRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../common/constants");
var _request_schema = require("../../../../common/risk_engine/risk_score_preview/request_schema");
var _route_validation = require("../../../utils/build_validation/route_validation");
var _risk_score_service = require("../risk_score_service");
var _helpers = require("../helpers");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskScorePreviewRoute = (router, logger) => {
  router.post({
    path: _constants.RISK_SCORE_PREVIEW_URL,
    validate: {
      body: (0, _route_validation.buildRouteValidation)(_request_schema.riskScorePreviewRequestSchema)
    },
    options: {
      tags: ['access:securitySolution']
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    const soClient = (await context.core).savedObjects.client;
    const siemClient = (await context.securitySolution).getAppClient();
    const riskScore = (0, _risk_score_service.riskScoreService)({
      esClient,
      logger
    });
    const {
      after_keys: userAfterKeys,
      data_view_id: dataViewId,
      debug,
      page_size: userPageSize,
      identifier_type: identifierType,
      filter,
      range: userRange,
      weights
    } = request.body;
    try {
      let index;
      if (dataViewId) {
        const dataViewIndex = await (0, _helpers.getRiskInputsIndex)({
          dataViewId,
          logger,
          soClient
        });
        if (!dataViewIndex) {
          return siemResponse.error({
            statusCode: 404,
            body: (0, _translations.DATAVIEW_NOT_FOUND)(dataViewId)
          });
        }
        index = dataViewIndex;
      }
      index ??= siemClient.getAlertsIndex();
      const afterKeys = userAfterKeys !== null && userAfterKeys !== void 0 ? userAfterKeys : {};
      const range = userRange !== null && userRange !== void 0 ? userRange : {
        start: 'now-15d',
        end: 'now'
      };
      const pageSize = userPageSize !== null && userPageSize !== void 0 ? userPageSize : _constants.DEFAULT_RISK_SCORE_PAGE_SIZE;
      const result = await riskScore.getScores({
        afterKeys,
        debug,
        pageSize,
        identifierType,
        index,
        filter,
        range,
        weights
      });
      return response.ok({
        body: result
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        }
      });
    }
  });
};
exports.riskScorePreviewRoute = riskScorePreviewRoute;