"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskInputsIndex = exports.getFieldForIdentifierAgg = exports.getAfterKeyForIdentifierType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRiskInputsIndex = async ({
  dataViewId,
  logger,
  soClient
}) => {
  try {
    const dataView = await soClient.get('index-pattern', dataViewId);
    return dataView.attributes.title;
  } catch (e) {
    logger.debug(`No dataview found for ID '${dataViewId}'`);
  }
};
exports.getRiskInputsIndex = getRiskInputsIndex;
const getFieldForIdentifierAgg = identifierType => identifierType === 'host' ? 'host.name' : 'user.name';
exports.getFieldForIdentifierAgg = getFieldForIdentifierAgg;
const getAfterKeyForIdentifierType = ({
  afterKeys,
  identifierType
}) => afterKeys[identifierType];
exports.getAfterKeyForIdentifierType = getAfterKeyForIdentifierType;