"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.totalFieldsLimit = exports.riskFieldMap = exports.mappingComponentName = exports.ilmPolicyName = exports.ilmPolicy = exports.getIndexPattern = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ilmPolicy = {
  _meta: {
    managed: true
  },
  phases: {
    hot: {
      actions: {
        rollover: {
          max_age: '30d',
          max_primary_shard_size: '50gb'
        }
      }
    }
  }
};
exports.ilmPolicy = ilmPolicy;
const riskFieldMap = {
  '@timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  identifierField: {
    type: 'keyword',
    array: false,
    required: false
  },
  identifierValue: {
    type: 'keyword',
    array: false,
    required: false
  },
  level: {
    type: 'keyword',
    array: false,
    required: false
  },
  totalScore: {
    type: 'float',
    array: false,
    required: false
  },
  totalScoreNormalized: {
    type: 'float',
    array: false,
    required: false
  },
  alertsScore: {
    type: 'float',
    array: false,
    required: false
  },
  otherScore: {
    type: 'float',
    array: false,
    required: false
  },
  riskiestInputs: {
    type: 'nested',
    required: false
  },
  'riskiestInputs.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'riskiestInputs.index': {
    type: 'keyword',
    array: false,
    required: false
  },
  'riskiestInputs.riskScore': {
    type: 'float',
    array: false,
    required: false
  }
};
exports.riskFieldMap = riskFieldMap;
const ilmPolicyName = '.risk-score-ilm-policy';
exports.ilmPolicyName = ilmPolicyName;
const mappingComponentName = '.risk-score-mappings';
exports.mappingComponentName = mappingComponentName;
const totalFieldsLimit = 1000;
exports.totalFieldsLimit = totalFieldsLimit;
const riskScoreBaseIndexName = 'risk-score';
const getIndexPattern = namespace => ({
  template: `.${riskScoreBaseIndexName}.${riskScoreBaseIndexName}-${namespace}-index-template`,
  alias: `${riskScoreBaseIndexName}.${riskScoreBaseIndexName}-${namespace}`
});
exports.getIndexPattern = getIndexPattern;