"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVersionBuckets = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getVersionBuckets = ruleVersionsMap => {
  const currentRules = [];
  const installableRules = [];
  const totalAvailableRules = [];
  const upgradeableRules = [];
  ruleVersionsMap.forEach(({
    current,
    target
  }) => {
    if (target != null) {
      // If this rule is available in the package
      totalAvailableRules.push(target);
    }
    if (current != null) {
      // If this rule is installed
      currentRules.push(current);
    }
    if (current == null && target != null) {
      // If this rule is not installed
      installableRules.push(target);
    }
    if (current != null && target != null && current.version < target.version) {
      // If this rule is installed but outdated
      upgradeableRules.push({
        current,
        target
      });
    }
  });
  return {
    currentRules,
    installableRules,
    upgradeableRules,
    totalAvailableRules
  };
};
exports.getVersionBuckets = getVersionBuckets;