"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardsByTagsRoute = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../common/constants");
var _utils = require("../../detection_engine/routes/utils");
var _common = require("../../timeline/utils/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDashboardsParamsSchema = _configSchema.schema.object({
  tagIds: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const getDashboardsByTagsRoute = (router, logger, security) => {
  router.post({
    path: _constants.INTERNAL_DASHBOARDS_URL,
    validate: {
      body: getDashboardsParamsSchema
    },
    options: {
      tags: ['access:securitySolution']
    }
  }, async (context, request, response) => {
    const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, security, request);
    const savedObjectsClient = (await frameworkRequest.context.core).savedObjects.client;
    const {
      tagIds
    } = request.body;
    try {
      var _dashboardsResponse$s;
      const dashboardsResponse = await savedObjectsClient.find({
        type: 'dashboard',
        hasReference: tagIds.map(id => ({
          id,
          type: 'tag'
        }))
      });
      const dashboards = (_dashboardsResponse$s = dashboardsResponse.saved_objects) !== null && _dashboardsResponse$s !== void 0 ? _dashboardsResponse$s : [];
      return response.ok({
        body: dashboards
      });
    } catch (err) {
      var _error$statusCode;
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      logger.error(`Failed to find dashboards tags - ${JSON.stringify(error.message)}`);
      const siemResponse = (0, _utils.buildSiemResponse)(response);
      return siemResponse.error({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: _i18n.i18n.translate('xpack.securitySolution.dashboards.getSecuritySolutionDashboardsErrorTitle', {
          values: {
            message: error.message
          },
          defaultMessage: `Failed to find dashboards - {message}`
        })
      });
    }
  });
};
exports.getDashboardsByTagsRoute = getDashboardsByTagsRoute;