"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securitySubFeaturesMap = exports.SecuritySubFeatureId = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const endpointListSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.endpointList.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Endpoint List access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.endpointList', {
    defaultMessage: 'Endpoint List'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.endpointList.description', {
    defaultMessage: 'Displays all hosts running Elastic Defend and their relevant integration details.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_common.APP_ID}-writeEndpointList`, `${_common.APP_ID}-readEndpointList`],
      id: 'endpoint_list_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeEndpointList', 'readEndpointList']
    }, {
      api: [`${_common.APP_ID}-readEndpointList`],
      id: 'endpoint_list_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readEndpointList']
    }]
  }]
};
const trustedApplicationsSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.trustedApplications.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Trusted Applications access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.trustedApplications', {
    defaultMessage: 'Trusted Applications'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.trustedApplications.description', {
    defaultMessage: 'Helps mitigate conflicts with other software, usually other antivirus or endpoint security applications.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_common.APP_ID}-writeTrustedApplications`, `${_common.APP_ID}-readTrustedApplications`],
      id: 'trusted_applications_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeTrustedApplications', 'readTrustedApplications']
    }, {
      api: ['lists-read', 'lists-summary', `${_common.APP_ID}-readTrustedApplications`],
      id: 'trusted_applications_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readTrustedApplications']
    }]
  }]
};
const hostIsolationExceptionsSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolationExceptions.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Host Isolation Exceptions access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolationExceptions', {
    defaultMessage: 'Host Isolation Exceptions'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolationExceptions.description', {
    defaultMessage: 'Add specific IP addresses that isolated hosts are still allowed to communicate with, even when isolated from the rest of the network.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_common.APP_ID}-deleteHostIsolationExceptions`, `${_common.APP_ID}-readHostIsolationExceptions`],
      id: 'host_isolation_exceptions_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['readHostIsolationExceptions', 'deleteHostIsolationExceptions']
    }, {
      api: ['lists-read', 'lists-summary', `${_common.APP_ID}-readHostIsolationExceptions`],
      id: 'host_isolation_exceptions_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readHostIsolationExceptions']
    }]
  }]
};
const blocklistSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.blockList.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Blocklist access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.blockList', {
    defaultMessage: 'Blocklist'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.blockList.description', {
    defaultMessage: 'Extend Elastic Defend’s protection against malicious processes and protect against potentially harmful applications.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_common.APP_ID}-writeBlocklist`, `${_common.APP_ID}-readBlocklist`],
      id: 'blocklist_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeBlocklist', 'readBlocklist']
    }, {
      api: ['lists-read', 'lists-summary', `${_common.APP_ID}-readBlocklist`],
      id: 'blocklist_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readBlocklist']
    }]
  }]
};
const eventFiltersSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.eventFilters.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Event Filters access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.eventFilters', {
    defaultMessage: 'Event Filters'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.eventFilters.description', {
    defaultMessage: 'Filter out endpoint events that you do not need or want stored in Elasticsearch.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_common.APP_ID}-writeEventFilters`, `${_common.APP_ID}-readEventFilters`],
      id: 'event_filters_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeEventFilters', 'readEventFilters']
    }, {
      api: ['lists-read', 'lists-summary', `${_common.APP_ID}-readEventFilters`],
      id: 'event_filters_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readEventFilters']
    }]
  }]
};
const policyManagementSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.policyManagement.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Policy Management access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.policyManagement', {
    defaultMessage: 'Elastic Defend Policy Management'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.policyManagement.description', {
    defaultMessage: 'Access the Elastic Defend integration policy to configure protections, event collection, and advanced policy features.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_common.APP_ID}-writePolicyManagement`, `${_common.APP_ID}-readPolicyManagement`],
      id: 'policy_management_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writePolicyManagement', 'readPolicyManagement']
    }, {
      api: [`${_common.APP_ID}-readPolicyManagement`],
      id: 'policy_management_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readPolicyManagement']
    }]
  }]
};
const responseActionsHistorySubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.responseActionsHistory.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Response Actions History access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.responseActionsHistory', {
    defaultMessage: 'Response Actions History'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.responseActionsHistory.description', {
    defaultMessage: 'Access the history of response actions performed on endpoints.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_common.APP_ID}-writeActionsLogManagement`, `${_common.APP_ID}-readActionsLogManagement`],
      id: 'actions_log_management_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeActionsLogManagement', 'readActionsLogManagement']
    }, {
      api: [`${_common.APP_ID}-readActionsLogManagement`],
      id: 'actions_log_management_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readActionsLogManagement']
    }]
  }]
};
const hostIsolationSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolation.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Host Isolation access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolation', {
    defaultMessage: 'Host Isolation'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolation.description', {
    defaultMessage: 'Perform the "isolate" and "release" response actions.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_common.APP_ID}-writeHostIsolationRelease`],
      id: 'host_isolation_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeHostIsolationRelease']
    }]
  }]
};
const processOperationsSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.processOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Process Operations access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.processOperations', {
    defaultMessage: 'Process Operations'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.processOperations.description', {
    defaultMessage: 'Perform process-related response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_common.APP_ID}-writeProcessOperations`],
      id: 'process_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeProcessOperations']
    }]
  }]
};
const fileOperationsSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.fileOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for File Operations access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.fileOperations', {
    defaultMessage: 'File Operations'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.fileOperations.description', {
    defaultMessage: 'Perform file-related response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_common.APP_ID}-writeFileOperations`],
      id: 'file_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeFileOperations']
    }]
  }]
};

// execute operations are not available in 8.7,
// but will be available in 8.8
const executeActionSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.executeOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Execute Operations access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.executeOperations', {
    defaultMessage: 'Execute Operations'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.executeOperations.description', {
    // TODO: Update this description before 8.8 FF
    defaultMessage: 'Perform script execution on the endpoint.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_common.APP_ID}-writeExecuteOperations`],
      id: 'execute_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeExecuteOperations']
    }]
  }]
};
let SecuritySubFeatureId; // Defines all the ordered Security subFeatures available
exports.SecuritySubFeatureId = SecuritySubFeatureId;
(function (SecuritySubFeatureId) {
  SecuritySubFeatureId["endpointList"] = "endpointListSubFeature";
  SecuritySubFeatureId["trustedApplications"] = "trustedApplicationsSubFeature";
  SecuritySubFeatureId["hostIsolationExceptions"] = "hostIsolationExceptionsSubFeature";
  SecuritySubFeatureId["blocklist"] = "blocklistSubFeature";
  SecuritySubFeatureId["eventFilters"] = "eventFiltersSubFeature";
  SecuritySubFeatureId["policyManagement"] = "policyManagementSubFeature";
  SecuritySubFeatureId["responseActionsHistory"] = "responseActionsHistorySubFeature";
  SecuritySubFeatureId["hostIsolation"] = "hostIsolationSubFeature";
  SecuritySubFeatureId["processOperations"] = "processOperationsSubFeature";
  SecuritySubFeatureId["fileOperations"] = "fileOperationsSubFeature";
  SecuritySubFeatureId["executeAction"] = "executeActionSubFeature";
})(SecuritySubFeatureId || (exports.SecuritySubFeatureId = SecuritySubFeatureId = {}));
const securitySubFeaturesMap = Object.freeze(new Map([[SecuritySubFeatureId.endpointList, endpointListSubFeature], [SecuritySubFeatureId.trustedApplications, trustedApplicationsSubFeature], [SecuritySubFeatureId.hostIsolationExceptions, hostIsolationExceptionsSubFeature], [SecuritySubFeatureId.blocklist, blocklistSubFeature], [SecuritySubFeatureId.eventFilters, eventFiltersSubFeature], [SecuritySubFeatureId.policyManagement, policyManagementSubFeature], [SecuritySubFeatureId.responseActionsHistory, responseActionsHistorySubFeature], [SecuritySubFeatureId.hostIsolation, hostIsolationSubFeature], [SecuritySubFeatureId.processOperations, processOperationsSubFeature], [SecuritySubFeatureId.fileOperations, fileOperationsSubFeature], [SecuritySubFeatureId.executeAction, executeActionSubFeature]]));
exports.securitySubFeaturesMap = securitySubFeaturesMap;