"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityBaseKibanaSubFeatureIds = exports.getSecurityBaseKibanaFeature = exports.getSecurityAppFeaturesConfig = void 0;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("@kbn/data-views-plugin/common");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _security_kibana_sub_features = require("./security_kibana_sub_features");
var _constants = require("../../../common/constants");
var _saved_objects = require("../../saved_objects");
var _app_features = require("../../../common/types/app_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Same as the plugin id defined by Cloud Security Posture
const CLOUD_POSTURE_APP_ID = 'csp';
// Same as the saved-object type for rules defined by Cloud Security Posture
const CLOUD_POSTURE_SAVED_OBJECT_RULE_TYPE = 'csp_rule';
const SECURITY_RULE_TYPES = [_constants.LEGACY_NOTIFICATIONS_ID, _securitysolutionRules.EQL_RULE_TYPE_ID, _securitysolutionRules.INDICATOR_RULE_TYPE_ID, _securitysolutionRules.ML_RULE_TYPE_ID, _securitysolutionRules.QUERY_RULE_TYPE_ID, _securitysolutionRules.SAVED_QUERY_RULE_TYPE_ID, _securitysolutionRules.THRESHOLD_RULE_TYPE_ID, _securitysolutionRules.NEW_TERMS_RULE_TYPE_ID];
const getSecurityBaseKibanaFeature = () => ({
  id: _constants.SERVER_APP_ID,
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.linkSecuritySolutionTitle', {
    defaultMessage: 'Security'
  }),
  order: 1100,
  category: _server.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.APP_ID, CLOUD_POSTURE_APP_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: SECURITY_RULE_TYPES,
  privileges: {
    all: {
      app: [_constants.APP_ID, CLOUD_POSTURE_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'lists-all', 'lists-read', 'lists-summary', 'rac', 'cloud-security-posture-all', 'cloud-security-posture-read'],
      savedObject: {
        all: ['alert', 'exception-list', _securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC, _common.DATA_VIEW_SAVED_OBJECT_TYPE, ..._saved_objects.savedObjectTypes, CLOUD_POSTURE_SAVED_OBJECT_RULE_TYPE],
        read: []
      },
      alerting: {
        rule: {
          all: SECURITY_RULE_TYPES
        },
        alert: {
          all: SECURITY_RULE_TYPES
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'crud']
    },
    read: {
      app: [_constants.APP_ID, CLOUD_POSTURE_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'lists-read', 'rac', 'cloud-security-posture-read'],
      savedObject: {
        all: [],
        read: ['exception-list', _securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC, _common.DATA_VIEW_SAVED_OBJECT_TYPE, ..._saved_objects.savedObjectTypes, CLOUD_POSTURE_SAVED_OBJECT_RULE_TYPE]
      },
      alerting: {
        rule: {
          read: SECURITY_RULE_TYPES
        },
        alert: {
          all: SECURITY_RULE_TYPES
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show']
    }
  }
});
exports.getSecurityBaseKibanaFeature = getSecurityBaseKibanaFeature;
const getSecurityBaseKibanaSubFeatureIds = _ => [_security_kibana_sub_features.SecuritySubFeatureId.hostIsolationExceptions, _security_kibana_sub_features.SecuritySubFeatureId.hostIsolation];

/**
 * Maps the AppFeatures keys to Kibana privileges that will be merged
 * into the base privileges config for the Security app.
 *
 * Privileges can be added in different ways:
 * - `privileges`: the privileges that will be added directly into the main Security feature.
 * - `subFeatureIds`: the ids of the sub-features that will be added into the Security subFeatures entry.
 * - `subFeaturesPrivileges`: the privileges that will be added into the existing Security subFeature with the privilege `id` specified.
 */
exports.getSecurityBaseKibanaSubFeatureIds = getSecurityBaseKibanaSubFeatureIds;
const getSecurityAppFeaturesConfig = _ => {
  return {
    [_app_features.AppFeatureSecurityKey.advancedInsights]: {
      privileges: {
        all: {
          ui: ['entity-analytics'],
          api: [`${_constants.APP_ID}-entity-analytics`]
        },
        read: {
          ui: ['entity-analytics'],
          api: [`${_constants.APP_ID}-entity-analytics`]
        }
      }
    },
    [_app_features.AppFeatureSecurityKey.endpointResponseActions]: {
      subFeatureIds: [_security_kibana_sub_features.SecuritySubFeatureId.processOperations, _security_kibana_sub_features.SecuritySubFeatureId.fileOperations, _security_kibana_sub_features.SecuritySubFeatureId.executeAction],
      subFeaturesPrivileges: [{
        id: 'host_isolation_all',
        api: [`${_constants.APP_ID}-writeHostIsolation`],
        ui: ['writeHostIsolation']
      }]
    },
    [_app_features.AppFeatureSecurityKey.endpointExceptions]: {
      subFeatureIds: [_security_kibana_sub_features.SecuritySubFeatureId.trustedApplications, _security_kibana_sub_features.SecuritySubFeatureId.blocklist, _security_kibana_sub_features.SecuritySubFeatureId.eventFilters, _security_kibana_sub_features.SecuritySubFeatureId.policyManagement, _security_kibana_sub_features.SecuritySubFeatureId.endpointList, _security_kibana_sub_features.SecuritySubFeatureId.responseActionsHistory],
      subFeaturesPrivileges: [{
        id: 'host_isolation_exceptions_all',
        api: [`${_constants.APP_ID}-accessHostIsolationExceptions`, `${_constants.APP_ID}-writeHostIsolationExceptions`],
        ui: ['accessHostIsolationExceptions', 'writeHostIsolationExceptions']
      }, {
        id: 'host_isolation_exceptions_read',
        api: [`${_constants.APP_ID}-accessHostIsolationExceptions`],
        ui: ['accessHostIsolationExceptions']
      }]
    }
  };
};
exports.getSecurityAppFeaturesConfig = getSecurityAppFeaturesConfig;