"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.casesSubFeaturesMap = exports.CasesSubFeatureId = void 0;
var _i18n = require("@kbn/i18n");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _common = require("@kbn/cases-plugin/common");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const casesCapabilities = (0, _common.createUICapabilities)();
const casesApiTags = (0, _common.getApiTags)(_constants.APP_ID);
const deleteCasesSubFeature = {
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.deleteSubFeatureName', {
    defaultMessage: 'Delete'
  }),
  privilegeGroups: [{
    groupType: 'independent',
    privileges: [{
      api: casesApiTags.delete,
      id: 'cases_delete',
      name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.deleteSubFeatureDetails', {
        defaultMessage: 'Delete cases and comments'
      }),
      includeIn: 'all',
      savedObject: {
        all: [..._saved_objects.hiddenTypes],
        read: [..._saved_objects.hiddenTypes]
      },
      cases: {
        delete: [_constants.APP_ID]
      },
      ui: casesCapabilities.delete
    }]
  }]
};
let CasesSubFeatureId; // Defines all the ordered Security Cases subFeatures available
exports.CasesSubFeatureId = CasesSubFeatureId;
(function (CasesSubFeatureId) {
  CasesSubFeatureId["deleteCases"] = "deleteCasesSubFeature";
})(CasesSubFeatureId || (exports.CasesSubFeatureId = CasesSubFeatureId = {}));
const casesSubFeaturesMap = Object.freeze(new Map([[CasesSubFeatureId.deleteCases, deleteCasesSubFeature]]));
exports.casesSubFeaturesMap = casesSubFeaturesMap;