"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppFeatures = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _security_kibana_features = require("./security_kibana_features");
var _security_cases_kibana_features = require("./security_cases_kibana_features");
var _app_features_config_merger = require("./app_features_config_merger");
var _security_cases_kibana_sub_features = require("./security_cases_kibana_sub_features");
var _security_kibana_sub_features = require("./security_kibana_sub_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AppFeatures {
  constructor(logger, experimentalFeatures) {
    (0, _defineProperty2.default)(this, "securityFeatureConfigMerger", void 0);
    (0, _defineProperty2.default)(this, "casesFeatureConfigMerger", void 0);
    (0, _defineProperty2.default)(this, "appFeatures", void 0);
    (0, _defineProperty2.default)(this, "featuresSetup", void 0);
    this.logger = logger;
    this.experimentalFeatures = experimentalFeatures;
    this.securityFeatureConfigMerger = new _app_features_config_merger.AppFeaturesConfigMerger(this.logger, _security_kibana_sub_features.securitySubFeaturesMap);
    this.casesFeatureConfigMerger = new _app_features_config_merger.AppFeaturesConfigMerger(this.logger, _security_cases_kibana_sub_features.casesSubFeaturesMap);
  }
  init(featuresSetup) {
    this.featuresSetup = featuresSetup;
  }
  set(appFeatureKeys) {
    if (this.appFeatures) {
      throw new Error('AppFeatures has already been initialized');
    }
    this.appFeatures = new Set(appFeatureKeys);
    this.registerEnabledKibanaFeatures();
  }
  isEnabled(appFeatureKey) {
    if (!this.appFeatures) {
      throw new Error('AppFeatures has not been initialized');
    }
    return this.appFeatures.has(appFeatureKey);
  }
  registerEnabledKibanaFeatures() {
    if (this.featuresSetup == null) {
      throw new Error('Cannot sync kibana features as featuresSetup is not present. Did you call init?');
    }
    // register main security Kibana features
    const securityBaseKibanaFeature = (0, _security_kibana_features.getSecurityBaseKibanaFeature)();
    const securityBaseKibanaSubFeatureIds = (0, _security_kibana_features.getSecurityBaseKibanaSubFeatureIds)(this.experimentalFeatures);
    const enabledSecurityAppFeaturesConfigs = this.getEnabledAppFeaturesConfigs((0, _security_kibana_features.getSecurityAppFeaturesConfig)(this.experimentalFeatures));
    this.featuresSetup.registerKibanaFeature(this.securityFeatureConfigMerger.mergeAppFeatureConfigs(securityBaseKibanaFeature, securityBaseKibanaSubFeatureIds, enabledSecurityAppFeaturesConfigs));

    // register security cases Kibana features
    const securityCasesBaseKibanaFeature = (0, _security_cases_kibana_features.getCasesBaseKibanaFeature)();
    const securityCasesBaseKibanaSubFeatureIds = (0, _security_cases_kibana_features.getCasesBaseKibanaSubFeatureIds)();
    const enabledCasesAppFeaturesConfigs = this.getEnabledAppFeaturesConfigs((0, _security_cases_kibana_features.getCasesAppFeaturesConfig)());
    this.featuresSetup.registerKibanaFeature(this.casesFeatureConfigMerger.mergeAppFeatureConfigs(securityCasesBaseKibanaFeature, securityCasesBaseKibanaSubFeatureIds, enabledCasesAppFeaturesConfigs));
  }
  getEnabledAppFeaturesConfigs(appFeaturesConfigs) {
    return Object.entries(appFeaturesConfigs).reduce((acc, [appFeatureKey, appFeatureConfig]) => {
      if (this.isEnabled(appFeatureKey)) {
        acc.push(appFeatureConfig);
      }
      return acc;
    }, []);
  }
}
exports.AppFeatures = AppFeatures;