"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTimelineEpic = exports.convertTimelineAsInput = void 0;
var _fp = require("lodash/fp");
var _rxjs = require("rxjs");
var _esQuery = require("@kbn/es-query");
var _operators = require("rxjs/operators");
var _api = require("../../../../common/types/timeline/api");
var _actions = require("../../../common/store/app/actions");
var _api2 = require("../../containers/api");
var _all = require("../../containers/all");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _actions2 = require("./actions");
var _epic_note = require("./epic_note");
var _epic_pinned_event = require("./epic_pinned_event");
var _epic_favorite = require("./epic_favorite");
var _helpers = require("./helpers");
var _epic_dispatcher_timeline_persistence_queue = require("./epic_dispatcher_timeline_persistence_queue");
var _my_epic_timeline_id = require("./my_epic_timeline_id");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timelineActionsType = [_actions2.applyKqlFilterQuery.type, _actions2.addProvider.type, _actions2.addTimeline.type, _actions2.dataProviderEdited.type, _actions2.removeProvider.type, _actions2.saveTimeline.type, _actions2.setExcludedRowRendererIds.type, _actions2.setFilters.type, _actions2.setSavedQueryId.type, _actions2.updateDataProviderEnabled.type, _actions2.updateDataProviderExcluded.type, _actions2.updateDataProviderType.type, _actions2.updateEqlOptions.type, _actions2.updateKqlMode.type, _actions2.updateProviders.type, _actions2.updateTitleAndDescription.type, _actions2.updateDataView.type, _actions2.removeColumn.type, _actions2.updateColumns.type, _actions2.updateSort.type, _actions2.updateRange.type, _actions2.upsertColumn.type];
const isItAtimelineAction = timelineId => timelineId && timelineId.toLowerCase().startsWith('timeline');
const createTimelineEpic = () => (action$, state$, {
  selectAllTimelineQuery,
  selectNotesByIdSelector,
  timelineByIdSelector,
  timelineTimeRangeSelector,
  kibana$
}) => {
  const timeline$ = state$.pipe((0, _operators.map)(timelineByIdSelector), (0, _operators.filter)(_helpers.isNotNull));
  const allTimelineQuery$ = state$.pipe((0, _operators.map)(state => {
    const getQuery = selectAllTimelineQuery();
    return getQuery(state, _all.ALL_TIMELINE_QUERY_ID);
  }), (0, _operators.filter)(_helpers.isNotNull));
  const notes$ = state$.pipe((0, _operators.map)(selectNotesByIdSelector), (0, _operators.filter)(_helpers.isNotNull));
  const timelineTimeRange$ = state$.pipe((0, _operators.map)(timelineTimeRangeSelector), (0, _operators.filter)(_helpers.isNotNull));
  return (0, _rxjs.merge)(action$.pipe((0, _operators.withLatestFrom)(timeline$), (0, _operators.filter)(([action, timeline]) => {
    const timelineId = (0, _fp.get)('payload.id', action);
    const timelineObj = timeline[timelineId];
    if (action.type === _actions.addError.type) {
      return true;
    }
    if (isItAtimelineAction(timelineId) && timelineObj != null && timelineObj.status != null && _api.TimelineStatus.immutable === timelineObj.status) {
      return false;
    } else if (action.type === _actions2.createTimeline.type && isItAtimelineAction(timelineId)) {
      _my_epic_timeline_id.myEpicTimelineId.setTimelineVersion(null);
      _my_epic_timeline_id.myEpicTimelineId.setTimelineId(null);
      _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineId(null);
      _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineVersion(null);
    } else if (action.type === _actions2.addTimeline.type && isItAtimelineAction(timelineId)) {
      const addNewTimeline = (0, _fp.get)('payload.timeline', action);
      _my_epic_timeline_id.myEpicTimelineId.setTimelineId(addNewTimeline.savedObjectId);
      _my_epic_timeline_id.myEpicTimelineId.setTimelineVersion(addNewTimeline.version);
      _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineId(addNewTimeline.templateTimelineId);
      _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineVersion(addNewTimeline.templateTimelineVersion);
      return (0, _fp.getOr)(false, 'payload.savedTimeline', action);
    } else if (timelineActionsType.includes(action.type) && !timelineObj.isLoading && isItAtimelineAction(timelineId)) {
      return true;
    }
  }), (0, _operators.debounceTime)(500), (0, _operators.mergeMap)(([action]) => {
    _epic_dispatcher_timeline_persistence_queue.dispatcherTimelinePersistQueue.next({
      action
    });
    return (0, _rxjs.empty)();
  })), _epic_dispatcher_timeline_persistence_queue.dispatcherTimelinePersistQueue.pipe((0, _operators.delay)(500), (0, _operators.withLatestFrom)(timeline$, notes$, timelineTimeRange$), (0, _operators.concatMap)(([objAction, timeline, notes, timelineTimeRange]) => {
    const action = (0, _fp.get)('action', objAction);
    const timelineId = _my_epic_timeline_id.myEpicTimelineId.getTimelineId();
    const version = _my_epic_timeline_id.myEpicTimelineId.getTimelineVersion();
    const templateTimelineId = _my_epic_timeline_id.myEpicTimelineId.getTemplateTimelineId();
    const templateTimelineVersion = _my_epic_timeline_id.myEpicTimelineId.getTemplateTimelineVersion();
    if (_epic_note.timelineNoteActionsType.includes(action.type)) {
      return (0, _epic_note.epicPersistNote)(action, timeline, notes, action$, timeline$, notes$, allTimelineQuery$);
    } else if (_epic_pinned_event.timelinePinnedEventActionsType.includes(action.type)) {
      return (0, _epic_pinned_event.epicPersistPinnedEvent)(action, timeline, action$, timeline$, allTimelineQuery$);
    } else if (_epic_favorite.timelineFavoriteActionsType.includes(action.type)) {
      return (0, _epic_favorite.epicPersistTimelineFavorite)(action, timeline, action$, timeline$, allTimelineQuery$);
    } else if (timelineActionsType.includes(action.type)) {
      return (0, _rxjs.from)((0, _api2.persistTimeline)({
        timelineId,
        version,
        timeline: {
          ...convertTimelineAsInput(timeline[action.payload.id], timelineTimeRange),
          templateTimelineId,
          templateTimelineVersion
        }
      })).pipe((0, _operators.withLatestFrom)(timeline$, allTimelineQuery$, kibana$), (0, _operators.mergeMap)(([result, recentTimeline, allTimelineQuery, kibana]) => {
        var _response$timeline$up, _response$timeline$st, _response$timeline$ti, _response$timeline$te, _response$timeline$te2;
        const error = result;
        if (error.status_code != null && error.status_code === 405) {
          var _error$message;
          kibana.notifications.toasts.addDanger({
            title: i18n.UPDATE_TIMELINE_ERROR_TITLE,
            text: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : i18n.UPDATE_TIMELINE_ERROR_TEXT
          });
          return [(0, _actions2.endTimelineSaving)({
            id: action.payload.id
          })];
        }
        const savedTimeline = recentTimeline[action.payload.id];
        const response = (0, _fp.get)('data.persistTimeline', result);
        if (response == null) {
          return [(0, _actions2.endTimelineSaving)({
            id: action.payload.id
          })];
        }
        const callOutMsg = response.code === 403 ? [(0, _actions2.showCallOutUnauthorizedMsg)()] : [];
        if (allTimelineQuery.refetch != null) {
          allTimelineQuery.refetch();
        }
        return [response.code === 409 ? (0, _actions2.updateAutoSaveMsg)({
          timelineId: action.payload.id,
          newTimelineModel: omitTypenameInTimeline(savedTimeline, response.timeline)
        }) : (0, _actions2.updateTimeline)({
          id: action.payload.id,
          timeline: {
            ...savedTimeline,
            updated: (_response$timeline$up = response.timeline.updated) !== null && _response$timeline$up !== void 0 ? _response$timeline$up : undefined,
            savedObjectId: response.timeline.savedObjectId,
            version: response.timeline.version,
            status: (_response$timeline$st = response.timeline.status) !== null && _response$timeline$st !== void 0 ? _response$timeline$st : _api.TimelineStatus.active,
            timelineType: (_response$timeline$ti = response.timeline.timelineType) !== null && _response$timeline$ti !== void 0 ? _response$timeline$ti : _api.TimelineType.default,
            templateTimelineId: (_response$timeline$te = response.timeline.templateTimelineId) !== null && _response$timeline$te !== void 0 ? _response$timeline$te : null,
            templateTimelineVersion: (_response$timeline$te2 = response.timeline.templateTimelineVersion) !== null && _response$timeline$te2 !== void 0 ? _response$timeline$te2 : null,
            isSaving: false
          }
        }), ...callOutMsg, (0, _actions2.endTimelineSaving)({
          id: action.payload.id
        })];
      }), (0, _operators.startWith)((0, _actions2.startTimelineSaving)({
        id: action.payload.id
      })), (0, _operators.takeUntil)(action$.pipe((0, _operators.withLatestFrom)(timeline$), (0, _operators.filter)(([checkAction, updatedTimeline]) => {
        if (checkAction.type === _actions2.endTimelineSaving.type && updatedTimeline[(0, _fp.get)('payload.id', checkAction)].savedObjectId != null) {
          _my_epic_timeline_id.myEpicTimelineId.setTimelineId(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].savedObjectId);
          _my_epic_timeline_id.myEpicTimelineId.setTimelineVersion(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].version);
          _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineId(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].templateTimelineId);
          _my_epic_timeline_id.myEpicTimelineId.setTemplateTimelineVersion(updatedTimeline[(0, _fp.get)('payload.id', checkAction)].templateTimelineVersion);
          return true;
        }
        return false;
      }))));
    }
    return (0, _rxjs.empty)();
  })));
};
exports.createTimelineEpic = createTimelineEpic;
const timelineInput = {
  columns: null,
  dataProviders: null,
  dataViewId: null,
  description: null,
  eqlOptions: null,
  eventType: null,
  excludedRowRendererIds: null,
  filters: null,
  kqlMode: null,
  kqlQuery: null,
  indexNames: null,
  title: null,
  timelineType: _api.TimelineType.default,
  templateTimelineVersion: null,
  templateTimelineId: null,
  dateRange: null,
  savedQueryId: null,
  sort: null,
  status: null
};
const convertTimelineAsInput = (timeline, timelineTimeRange) => Object.keys(timelineInput).reduce((acc, key) => {
  if ((0, _fp.has)(key, timeline)) {
    if (key === 'kqlQuery') {
      return (0, _fp.set)(`${key}.filterQuery`, (0, _fp.get)(`${key}.filterQuery`, timeline), acc);
    } else if (key === 'dateRange') {
      return (0, _fp.set)(`${key}`, {
        start: timelineTimeRange.from,
        end: timelineTimeRange.to
      }, acc);
    } else if (key === 'columns' && (0, _fp.get)(key, timeline) != null) {
      return (0, _fp.set)(key, (0, _fp.get)(key, timeline).map(col => (0, _fp.omit)(['initialWidth', 'width', '__typename', 'esTypes'], col)), acc);
    } else if (key === 'filters' && (0, _fp.get)(key, timeline) != null) {
      const filters = (0, _fp.get)(key, timeline);
      return (0, _fp.set)(key, filters != null ? filters.map(myFilter => {
        const basicFilter = (0, _fp.omit)(['$state'], myFilter);
        return {
          ...basicFilter,
          meta: {
            ...basicFilter.meta,
            field: ((0, _esQuery.isMatchAllFilter)(basicFilter) || (0, _esQuery.isPhraseFilter)(basicFilter) || (0, _esQuery.isPhrasesFilter)(basicFilter) || (0, _esQuery.isRangeFilter)(basicFilter)) && basicFilter.meta.field != null ? convertToString(basicFilter.meta.field) : null,
            value: basicFilter.meta.value != null ? convertToString(basicFilter.meta.value) : null,
            params: basicFilter.meta.params != null ? convertToString(basicFilter.meta.params) : null
          },
          ...((0, _esQuery.isMatchAllFilter)(basicFilter) ? {
            query: {
              match_all: convertToString(basicFilter.query.match_all)
            }
          } : {
            match_all: null
          }),
          ...((0, _esQuery.isExistsFilter)(basicFilter) && basicFilter.query.exists != null ? {
            query: {
              exists: convertToString(basicFilter.query.exists)
            }
          } : {
            exists: null
          }),
          ...(((0, _esQuery.isQueryStringFilter)(basicFilter) || (0, _fp.get)('query', basicFilter) != null) && basicFilter.query != null ? {
            query: convertToString(basicFilter.query)
          } : {
            query: null
          }),
          ...((0, _esQuery.isRangeFilter)(basicFilter) && basicFilter.query.range != null ? {
            query: {
              range: convertToString(basicFilter.query.range)
            }
          } : {
            range: null
          }),
          ...((0, _esQuery.isScriptedRangeFilter)(basicFilter) && basicFilter.query.script != null /* TODO remove it when PR50713 is merged || esFilters.isPhraseFilter(basicFilter) */ ? {
            query: {
              script: convertToString(basicFilter.query.script)
            }
          } : {
            script: null
          })
        };
      }) : [], acc);
    }
    return (0, _fp.set)(key, (0, _fp.get)(key, timeline), acc);
  }
  return acc;
}, timelineInput);
exports.convertTimelineAsInput = convertTimelineAsInput;
const omitTypename = (key, value) => key === '__typename' ? undefined : value;
const omitTypenameInTimeline = (oldTimeline, newTimeline) => JSON.parse(JSON.stringify((0, _fp.merge)(oldTimeline, newTimeline)), omitTypename);
const convertToString = obj => {
  try {
    if ((0, _fp.isObject)(obj)) {
      return JSON.stringify(obj);
    }
    return (0, _fp.toString)(obj);
  } catch {
    return '';
  }
};