"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelinesPageComponent = exports.TimelinesPage = exports.DEFAULT_SEARCH_RESULTS_PER_PAGE = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRouterDom = require("react-router-dom");
var _timeline = require("../../../common/types/timeline");
var _api = require("../../../common/types/timeline/api");
var _header_page = require("../../common/components/header_page");
var _page_wrapper = require("../../common/components/page_wrapper");
var _kibana = require("../../common/lib/kibana");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _open_timeline = require("../components/open_timeline");
var _translations = require("../components/timeline/properties/translations");
var _new_template_timeline = require("../components/timeline/properties/new_template_timeline");
var _helpers = require("../components/timeline/properties/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../app/types");
var _sourcerer = require("../../common/containers/sourcerer");
var _landing_page = require("../../common/components/landing_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelinesContainer = _styledComponents.default.div`
  width: 100%;
`;
const DEFAULT_SEARCH_RESULTS_PER_PAGE = 10;
exports.DEFAULT_SEARCH_RESULTS_PER_PAGE = DEFAULT_SEARCH_RESULTS_PER_PAGE;
const TimelinesPageComponent = () => {
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const [importDataModalToggle, setImportDataModalToggle] = (0, _react.useState)(false);
  const onImportTimelineBtnClick = (0, _react.useCallback)(() => {
    setImportDataModalToggle(true);
  }, [setImportDataModalToggle]);
  const {
    indicesExist
  } = (0, _sourcerer.useSourcererDataView)();
  const capabilitiesCanUserCRUD = !!(0, _kibana.useKibana)().services.application.capabilities.siem.crud;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: i18n.PAGE_TITLE
  }, capabilitiesCanUserCRUD && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "indexOpen",
    onClick: onImportTimelineBtnClick,
    "data-test-subj": "open-import-data-modal-btn"
  }, i18n.ALL_TIMELINES_IMPORT_TIMELINE_TITLE)), tabName === _api.TimelineType.default ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_helpers.NewTimeline, {
    timelineId: _timeline.TimelineId.active,
    outline: true,
    "data-test-subj": "create-default-btn"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_new_template_timeline.NewTemplateTimeline, {
    outline: true,
    title: _translations.NEW_TEMPLATE_TIMELINE,
    "data-test-subj": "create-template-btn"
  })))), /*#__PURE__*/_react.default.createElement(TimelinesContainer, {
    "data-test-subj": "timelines-container"
  }, /*#__PURE__*/_react.default.createElement(_open_timeline.StatefulOpenTimeline, {
    defaultPageSize: DEFAULT_SEARCH_RESULTS_PER_PAGE,
    isModal: false,
    importDataModalToggle: importDataModalToggle && capabilitiesCanUserCRUD,
    setImportDataModalToggle: setImportDataModalToggle,
    title: i18n.ALL_TIMELINES_PANEL_TITLE,
    "data-test-subj": "stateful-open-timeline"
  })))) : /*#__PURE__*/_react.default.createElement(_landing_page.LandingPageComponent, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.timelines
  }));
};
exports.TimelinesPageComponent = TimelinesPageComponent;
const TimelinesPage = /*#__PURE__*/_react.default.memo(TimelinesPageComponent);
exports.TimelinesPage = TimelinesPage;