"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.persistPinnedEvent = void 0;
var _constants = require("../../../../common/constants");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const persistPinnedEvent = async ({
  eventId,
  pinnedEventId,
  timelineId
}) => {
  let requestBody;
  try {
    requestBody = JSON.stringify({
      eventId,
      pinnedEventId,
      timelineId
    });
  } catch (err) {
    return Promise.reject(new Error(`Failed to stringify query: ${JSON.stringify(err)}`));
  }
  const response = await _kibana.KibanaServices.get().http.patch(_constants.PINNED_EVENT_URL, {
    method: 'PATCH',
    body: requestBody
  });
  return response;
};
exports.persistPinnedEvent = persistPinnedEvent;