"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_KQL_TOOLTIP = exports.SEARCH_KQL_SELECTED_TEXT = exports.SEARCH_KQL_PLACEHOLDER = exports.SEARCH_DESCRIPTION = exports.FILTER_OR_SEARCH_WITH_KQL = exports.FILTER_KQL_TOOLTIP = exports.FILTER_KQL_SELECTED_TEXT = exports.FILTER_KQL_PLACEHOLDER = exports.FILTER_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterDescription', {
  defaultMessage: 'Events from the data providers above are filtered by the adjacent KQL'
});
exports.FILTER_DESCRIPTION = FILTER_DESCRIPTION;
const FILTER_KQL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterKqlTooltip', {
  defaultMessage: 'Events from the data providers above are filtered by this KQL'
});
exports.FILTER_KQL_TOOLTIP = FILTER_KQL_TOOLTIP;
const FILTER_KQL_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterKqlPlaceholder', {
  defaultMessage: 'Filter events'
});
exports.FILTER_KQL_PLACEHOLDER = FILTER_KQL_PLACEHOLDER;
const FILTER_KQL_SELECTED_TEXT = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterKqlSelectedText', {
  defaultMessage: 'Filter'
});
exports.FILTER_KQL_SELECTED_TEXT = FILTER_KQL_SELECTED_TEXT;
const SEARCH_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchDescription', {
  defaultMessage: 'Events from the data providers above are combined with results from the adjacent KQL'
});
exports.SEARCH_DESCRIPTION = SEARCH_DESCRIPTION;
const SEARCH_KQL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchKqlTooltip', {
  defaultMessage: 'Events from the data providers above are combined with results from this KQL'
});
exports.SEARCH_KQL_TOOLTIP = SEARCH_KQL_TOOLTIP;
const SEARCH_KQL_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchKqlPlaceholder', {
  defaultMessage: 'Search events'
});
exports.SEARCH_KQL_PLACEHOLDER = SEARCH_KQL_PLACEHOLDER;
const SEARCH_KQL_SELECTED_TEXT = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchKqlSelectedText', {
  defaultMessage: 'Search'
});
exports.SEARCH_KQL_SELECTED_TEXT = SEARCH_KQL_SELECTED_TEXT;
const FILTER_OR_SEARCH_WITH_KQL = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterOrSearchWithKql', {
  defaultMessage: 'Filter or Search with KQL'
});
exports.FILTER_OR_SEARCH_WITH_KQL = FILTER_OR_SEARCH_WITH_KQL;