"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSAVED_TIMELINE_WARNING = exports.TITLE = exports.TIMELINE_TITLE = exports.TIMELINE_DESCRIPTION = exports.SAVE_TIMELINE_TEMPLATE = exports.SAVE_TIMELINE = exports.SAVE = exports.OPTIONAL = exports.NAME_TIMELINE_TEMPLATE = exports.NAME_TIMELINE = exports.EDIT = exports.DISCARD_TIMELINE_TEMPLATE = exports.DISCARD_TIMELINE = exports.CLOSE_MODAL = exports.CALL_OUT_UNAUTHORIZED_MSG = exports.CALL_OUT_IMMUTABLE = void 0;
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../common/types/timeline/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CALL_OUT_UNAUTHORIZED_MSG = _i18n.i18n.translate('xpack.securitySolution.timeline.callOut.unauthorized.message.description', {
  defaultMessage: 'You can use Timeline to investigate events, but you do not have the required permissions to save timelines for future use. If you need to save timelines, contact your Kibana administrator.'
});
exports.CALL_OUT_UNAUTHORIZED_MSG = CALL_OUT_UNAUTHORIZED_MSG;
const CALL_OUT_IMMUTABLE = _i18n.i18n.translate('xpack.securitySolution.timeline.callOut.immutable.message.description', {
  defaultMessage: 'This prebuilt timeline template cannot be modified. To make changes, please duplicate this template and make modifications to the duplicate template.'
});
exports.CALL_OUT_IMMUTABLE = CALL_OUT_IMMUTABLE;
const EDIT = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.button', {
  defaultMessage: 'Edit timeline name and description'
});
exports.EDIT = EDIT;
const SAVE_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.header', {
  defaultMessage: 'Save Timeline'
});
exports.SAVE_TIMELINE = SAVE_TIMELINE;
const SAVE_TIMELINE_TEMPLATE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimelineTemplate.modal.header', {
  defaultMessage: 'Save Timeline Template'
});
exports.SAVE_TIMELINE_TEMPLATE = SAVE_TIMELINE_TEMPLATE;
const SAVE = _i18n.i18n.translate('xpack.securitySolution.timeline.nameTimeline.save.title', {
  defaultMessage: 'Save'
});
exports.SAVE = SAVE;
const NAME_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.nameTimeline.modal.header', {
  defaultMessage: 'Name Timeline'
});
exports.NAME_TIMELINE = NAME_TIMELINE;
const NAME_TIMELINE_TEMPLATE = _i18n.i18n.translate('xpack.securitySolution.timeline.nameTimelineTemplate.modal.header', {
  defaultMessage: 'Name Timeline Template'
});
exports.NAME_TIMELINE_TEMPLATE = NAME_TIMELINE_TEMPLATE;
const DISCARD_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.discard.title', {
  defaultMessage: 'Discard Timeline'
});
exports.DISCARD_TIMELINE = DISCARD_TIMELINE;
const DISCARD_TIMELINE_TEMPLATE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimelineTemplate.modal.discard.title', {
  defaultMessage: 'Discard Timeline Template'
});
exports.DISCARD_TIMELINE_TEMPLATE = DISCARD_TIMELINE_TEMPLATE;
const CLOSE_MODAL = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.close.title', {
  defaultMessage: 'Close'
});
exports.CLOSE_MODAL = CLOSE_MODAL;
const UNSAVED_TIMELINE_WARNING = timelineType => _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.warning.title', {
  values: {
    timeline: timelineType === _api.TimelineType.template ? 'timeline template' : 'timeline'
  },
  defaultMessage: 'You have an unsaved {timeline}. Do you wish to save it?'
});
exports.UNSAVED_TIMELINE_WARNING = UNSAVED_TIMELINE_WARNING;
const TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.titleTitle', {
  defaultMessage: 'Title'
});
exports.TITLE = TITLE;
const TIMELINE_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.titleAriaLabel', {
  defaultMessage: 'Title'
});
exports.TIMELINE_TITLE = TIMELINE_TITLE;
const TIMELINE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.descriptionLabel', {
  defaultMessage: 'Description'
});
exports.TIMELINE_DESCRIPTION = TIMELINE_DESCRIPTION;
const OPTIONAL = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.optionalLabel', {
  defaultMessage: 'Optional'
});
exports.OPTIONAL = OPTIONAL;